/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringDatagramChannel;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import io.netty.incubator.channel.uring.IOUringSocketChannel;
import java.util.concurrent.ThreadFactory;
import reactor.netty.resources.ColocatedEventLoopGroup;
import reactor.netty.resources.DefaultLoop;
import reactor.util.Logger;
import reactor.util.Loggers;

final class DefaultLoopIOUring
implements DefaultLoop {
    static final Logger log = Loggers.getLogger(DefaultLoopIOUring.class);
    static final boolean ioUring;

    DefaultLoopIOUring() {
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL getChannel(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return (CHANNEL)new IOUringSocketChannel();
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return (CHANNEL)new IOUringServerSocketChannel();
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return (CHANNEL)new IOUringDatagramChannel();
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> getChannelClass(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return IOUringSocketChannel.class;
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return IOUringServerSocketChannel.class;
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return IOUringDatagramChannel.class;
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public String getName() {
        return "io_uring";
    }

    @Override
    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return new IOUringEventLoopGroup(threads, factory);
    }

    @Override
    public boolean supportGroup(EventLoopGroup group) {
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).get();
        }
        return group instanceof IOUringEventLoopGroup;
    }

    static {
        boolean ioUringCheck = false;
        try {
            Class.forName("io.netty.incubator.channel.uring.IOUring");
            ioUringCheck = IOUring.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ioUring = ioUringCheck;
        if (log.isDebugEnabled()) {
            log.debug("Default io_uring support : " + ioUring);
        }
    }
}

