/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.isession.pool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.isession.pool.ISessionDataSetWrapper;
import org.apache.iotdb.isession.template.Template;
import org.apache.iotdb.isession.util.SystemStatus;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TSBackupConfigurationResp;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.record.Tablet;

public interface ISessionPool {
    public int currentAvailableSize();

    public int currentOccupiedSize();

    public void close();

    public void closeResultSet(ISessionDataSetWrapper var1);

    public void insertTablet(Tablet var1) throws IoTDBConnectionException, StatementExecutionException;

    public void insertTablet(Tablet var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedTablet(Tablet var1) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedTablet(Tablet var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void insertTablets(Map<String, Tablet> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedTablets(Map<String, Tablet> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void insertTablets(Map<String, Tablet> var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedTablets(Map<String, Tablet> var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    @Deprecated
    public void insertOneDeviceRecords(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertStringRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5, boolean var6) throws IoTDBConnectionException, StatementExecutionException;

    @Deprecated
    public void insertOneDeviceRecords(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5, boolean var6) throws IoTDBConnectionException, StatementExecutionException;

    public void insertStringRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4, boolean var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedStringRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5, boolean var6) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedStringRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4, boolean var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecord(String var1, long var2, List<String> var4, List<TSDataType> var5, List<Object> var6) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecord(String var1, long var2, List<String> var4, List<TSDataType> var5, List<Object> var6) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecord(String var1, long var2, List<String> var4, List<String> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecord(String var1, long var2, List<String> var4, List<String> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertTablet(Tablet var1) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertTablets(Map<String, Tablet> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertRecord(String var1, long var2, List<String> var4, List<String> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertRecord(String var1, long var2, List<String> var4, List<TSDataType> var5, List<Object> var6) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteTimeseries(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteTimeseries(List<String> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteData(String var1, long var2) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteData(List<String> var1, long var2) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteData(List<String> var1, long var2, long var4) throws IoTDBConnectionException, StatementExecutionException;

    public void setStorageGroup(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteStorageGroup(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteStorageGroups(List<String> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void createTimeseries(String var1, TSDataType var2, TSEncoding var3, CompressionType var4) throws IoTDBConnectionException, StatementExecutionException;

    public void createTimeseries(String var1, TSDataType var2, TSEncoding var3, CompressionType var4, Map<String, String> var5, Map<String, String> var6, Map<String, String> var7, String var8) throws IoTDBConnectionException, StatementExecutionException;

    public void createMultiTimeseries(List<String> var1, List<TSDataType> var2, List<TSEncoding> var3, List<CompressionType> var4, List<Map<String, String>> var5, List<Map<String, String>> var6, List<Map<String, String>> var7, List<String> var8) throws IoTDBConnectionException, StatementExecutionException;

    public boolean checkTimeseriesExists(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public void createSchemaTemplate(Template var1) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void createSchemaTemplate(String var1, List<String> var2, List<TSDataType> var3, List<TSEncoding> var4, List<CompressionType> var5, boolean var6) throws IOException, IoTDBConnectionException, StatementExecutionException;

    @Deprecated
    public void createSchemaTemplate(String var1, List<String> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<TSEncoding>> var5, List<CompressionType> var6) throws IoTDBConnectionException, StatementExecutionException;

    public void addAlignedMeasurementsInTemplate(String var1, List<String> var2, List<TSDataType> var3, List<TSEncoding> var4, List<CompressionType> var5) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void addAlignedMeasurementInTemplate(String var1, String var2, TSDataType var3, TSEncoding var4, CompressionType var5) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void addUnalignedMeasurementsInTemplate(String var1, List<String> var2, List<TSDataType> var3, List<TSEncoding> var4, List<CompressionType> var5) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void addUnalignedMeasurementInTemplate(String var1, String var2, TSDataType var3, TSEncoding var4, CompressionType var5) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void deleteNodeInTemplate(String var1, String var2) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public int countMeasurementsInTemplate(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public boolean isMeasurementInTemplate(String var1, String var2) throws StatementExecutionException, IoTDBConnectionException;

    public boolean isPathExistInTemplate(String var1, String var2) throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showMeasurementsInTemplate(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showMeasurementsInTemplate(String var1, String var2) throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showAllTemplates() throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showPathsTemplateSetOn(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showPathsTemplateUsingOn(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public void setSchemaTemplate(String var1, String var2) throws StatementExecutionException, IoTDBConnectionException;

    public void unsetSchemaTemplate(String var1, String var2) throws StatementExecutionException, IoTDBConnectionException;

    public void createTimeseriesOfTemplateOnPath(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public void deactivateTempalte(String var1, String var2) throws IoTDBConnectionException, StatementExecutionException;

    public void dropSchemaTemplate(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public ISessionDataSetWrapper executeQueryStatement(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public ISessionDataSetWrapper executeQueryStatement(String var1, long var2) throws IoTDBConnectionException, StatementExecutionException;

    public void executeNonQueryStatement(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public ISessionDataSetWrapper executeRawDataQuery(List<String> var1, long var2, long var4) throws IoTDBConnectionException, StatementExecutionException;

    public boolean operationSyncTransmit(ByteBuffer var1) throws IoTDBConnectionException, StatementExecutionException;

    public SystemStatus getSystemStatus() throws IoTDBConnectionException;

    public TSBackupConfigurationResp getBackupConfiguration() throws IoTDBConnectionException, StatementExecutionException;

    public int getMaxSize();

    public String getHost();

    public int getPort();

    public String getUser();

    public String getPassword();

    public int getFetchSize();

    public ZoneId getZoneId();

    public long getWaitToGetSessionTimeoutInMs();

    public boolean isEnableCompression();

    public boolean isEnableCacheLeader();

    public int getConnectionTimeoutInMs();

    public TSConnectionInfoResp fetchAllConnections() throws IoTDBConnectionException;
}

