/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import java.net.URI;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.ByteBufMono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientConnect;
import reactor.netty.http.client.HttpClientForm;
import reactor.netty.http.client.HttpClientOperations;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.util.annotation.Nullable;

final class HttpClientFinalizer
extends HttpClientConnect
implements HttpClient.RequestSender {
    static final Function<ChannelOperations<?, ?>, Publisher<ByteBuf>> contentReceiver = ChannelOperations::receive;
    static final Function<HttpClientOperations, HttpClientResponse> RESPONSE_ONLY = ops -> {
        HttpClientFinalizer.discard(ops);
        return ops;
    };

    HttpClientFinalizer(HttpClientConfig config) {
        super(config);
    }

    @Override
    public HttpClient.RequestSender uri(Mono<String> uri) {
        Objects.requireNonNull(uri, "uri");
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).deferredConf(config -> uri.map(s -> {
            config.uriStr = s;
            config.uri = null;
            return config;
        }));
        return (HttpClientFinalizer)dup;
    }

    @Override
    public HttpClient.RequestSender uri(String uri) {
        Objects.requireNonNull(uri, "uri");
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).uriStr = uri;
        ((HttpClientConfig)dup.configuration()).uri = null;
        return (HttpClientFinalizer)dup;
    }

    @Override
    public HttpClient.RequestSender uri(URI uri) {
        Objects.requireNonNull(uri, "uri");
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute: " + uri);
        }
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).uriStr = null;
        ((HttpClientConfig)dup.configuration()).uri = uri;
        return (HttpClientFinalizer)dup;
    }

    @Override
    public Mono<HttpClientResponse> response() {
        return this._connect().map(RESPONSE_ONLY);
    }

    @Override
    public <V> Flux<V> response(BiFunction<? super HttpClientResponse, ? super ByteBufFlux, ? extends Publisher<V>> receiver) {
        return this._connect().flatMapMany(resp -> Flux.from((Publisher)((Publisher)receiver.apply((HttpClientResponse)resp, (ByteBufFlux)resp.receive()))).doFinally(s -> HttpClientFinalizer.discard(resp)));
    }

    @Override
    public <V> Flux<V> responseConnection(BiFunction<? super HttpClientResponse, ? super Connection, ? extends Publisher<V>> receiver) {
        return this._connect().flatMapMany(resp -> Flux.from((Publisher)((Publisher)receiver.apply((HttpClientResponse)resp, (Connection)resp))));
    }

    @Override
    public ByteBufFlux responseContent() {
        ByteBufAllocator alloc = (ByteBufAllocator)this.configuration().options().get(ChannelOption.ALLOCATOR);
        if (alloc == null) {
            alloc = ByteBufAllocator.DEFAULT;
        }
        Mono<? extends Connection> connector = this.connect();
        return ByteBufFlux.fromInbound((Publisher)connector.flatMapMany(contentReceiver), (ByteBufAllocator)alloc);
    }

    @Override
    public <V> Mono<V> responseSingle(BiFunction<? super HttpClientResponse, ? super ByteBufMono, ? extends Mono<V>> receiver) {
        return this._connect().flatMap(resp -> ((Mono)receiver.apply((HttpClientResponse)resp, (ByteBufMono)resp.receive().aggregate())).doFinally(s -> HttpClientFinalizer.discard(resp)));
    }

    public HttpClientFinalizer send(BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> sender) {
        Objects.requireNonNull(sender, "requestBody");
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).body = sender;
        return (HttpClientFinalizer)dup;
    }

    public HttpClientFinalizer send(Publisher<? extends ByteBuf> requestBody) {
        Objects.requireNonNull(requestBody, "requestBody");
        return this.send((T req, U out) -> out.send(requestBody));
    }

    public HttpClientFinalizer sendForm(BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback, @Nullable Consumer<Flux<Long>> progress) {
        Objects.requireNonNull(formCallback, "formCallback");
        return this.send((T req, U out) -> {
            HttpClientOperations ops = (HttpClientOperations)out;
            return new HttpClientOperations.SendForm(ops, formCallback, progress);
        });
    }

    @Override
    protected HttpClient duplicate() {
        return new HttpClientFinalizer(new HttpClientConfig(this.config));
    }

    Mono<HttpClientOperations> _connect() {
        return this.connect();
    }

    static void discard(HttpClientOperations c) {
        if (!c.isInboundDisposed()) {
            c.discard();
        }
    }
}

