/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.exception.ReaderNotFoundException;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.rpc.thrift.GetAggrResultRequest;
import org.apache.iotdb.cluster.rpc.thrift.GetAllPathsResult;
import org.apache.iotdb.cluster.rpc.thrift.GroupByRequest;
import org.apache.iotdb.cluster.rpc.thrift.LastQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.MeasurementSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.MultSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PreviousFillRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotResp;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.SingleSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.TSDataService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.service.BaseSyncService;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.exception.filter.StatisticsClassException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSyncService
extends BaseSyncService
implements TSDataService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(DataSyncService.class);
    private DataGroupMember dataGroupMember;

    public DataSyncService(DataGroupMember member) {
        super(member);
        this.dataGroupMember = member;
    }

    public void sendSnapshot(SendSnapshotRequest request) throws TException {
        try {
            this.dataGroupMember.receiveSnapshot(request);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    public PullSnapshotResp pullSnapshot(PullSnapshotRequest request) throws TException {
        PullSnapshotResp pullSnapshotResp;
        try {
            pullSnapshotResp = this.dataGroupMember.getSnapshot(request);
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
        if (pullSnapshotResp == null) {
            return this.forwardPullSnapshot(request);
        }
        return pullSnapshotResp;
    }

    private PullSnapshotResp forwardPullSnapshot(PullSnapshotRequest request) throws TException {
        if (this.dataGroupMember.getLeader() != null && !ClusterConstant.EMPTY_NODE.equals(this.dataGroupMember.getLeader())) {
            logger.debug("{} forwarding a pull snapshot request to the leader {}", (Object)this.name, (Object)this.dataGroupMember.getLeader());
            SyncDataClient client = (SyncDataClient)this.dataGroupMember.getSyncClient(this.dataGroupMember.getLeader());
            if (client == null) {
                logger.error("{}, can not get the client for node={}", (Object)this.name, (Object)this.dataGroupMember.getLeader());
                throw new TException((Throwable)new LeaderUnknownException(this.dataGroupMember.getAllNodes()));
            }
            PullSnapshotResp pullSnapshotResp = null;
            try {
                pullSnapshotResp = client.pullSnapshot(request);
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                throw e;
            }
            finally {
                ClientUtils.putBackSyncClient((RaftService.Client)client);
            }
            return pullSnapshotResp;
        }
        throw new TException((Throwable)new LeaderUnknownException(this.dataGroupMember.getAllNodes()));
    }

    public PullSchemaResp pullTimeSeriesSchema(PullSchemaRequest request) throws TException {
        PullSchemaResp pullSchemaResp;
        if (this.dataGroupMember.getCharacter() == NodeCharacter.LEADER) {
            try {
                return this.dataGroupMember.getLocalQueryExecutor().queryTimeSeriesSchema(request);
            }
            catch (CheckConsistencyException | MetadataException e) {
                try {
                    this.dataGroupMember.getMetaGroupMember().syncLeaderWithConsistencyCheck(false);
                    return this.dataGroupMember.getLocalQueryExecutor().queryTimeSeriesSchema(request);
                }
                catch (CheckConsistencyException | MetadataException ex) {
                    throw new TException(ex);
                }
            }
        }
        this.dataGroupMember.waitLeader();
        SyncDataClient client = (SyncDataClient)this.dataGroupMember.getSyncClient(this.dataGroupMember.getLeader());
        if (client == null) {
            throw new TException((Throwable)new LeaderUnknownException(this.dataGroupMember.getAllNodes()));
        }
        try {
            pullSchemaResp = client.pullTimeSeriesSchema(request);
        }
        catch (TException te) {
            client.getInputProtocol().getTransport().close();
            throw te;
        }
        finally {
            ClientUtils.putBackSyncClient((RaftService.Client)client);
        }
        return pullSchemaResp;
    }

    public PullSchemaResp pullMeasurementSchema(PullSchemaRequest request) throws TException {
        PullSchemaResp pullSchemaResp;
        if (this.dataGroupMember.getCharacter() == NodeCharacter.LEADER) {
            try {
                return this.dataGroupMember.getLocalQueryExecutor().queryMeasurementSchema(request);
            }
            catch (CheckConsistencyException | MetadataException e) {
                try {
                    this.dataGroupMember.getMetaGroupMember().syncLeaderWithConsistencyCheck(false);
                    return this.dataGroupMember.getLocalQueryExecutor().queryMeasurementSchema(request);
                }
                catch (CheckConsistencyException | MetadataException ex) {
                    throw new TException(ex);
                }
            }
        }
        this.dataGroupMember.waitLeader();
        SyncDataClient client = (SyncDataClient)this.dataGroupMember.getSyncClient(this.dataGroupMember.getLeader());
        if (client == null) {
            throw new TException((Throwable)new LeaderUnknownException(this.dataGroupMember.getAllNodes()));
        }
        try {
            pullSchemaResp = client.pullMeasurementSchema(request);
        }
        catch (TException te) {
            client.getInputProtocol().getTransport().close();
            throw te;
        }
        finally {
            ClientUtils.putBackSyncClient((RaftService.Client)client);
        }
        return pullSchemaResp;
    }

    public long querySingleSeries(SingleSeriesQueryRequest request) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().querySingleSeries(request);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    public long queryMultSeries(MultSeriesQueryRequest request) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().queryMultSeries(request);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    public long querySingleSeriesByTimestamp(SingleSeriesQueryRequest request) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().querySingleSeriesByTimestamp(request);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    public void endQuery(RaftNode header, Node requester, long queryId) throws TException {
        try {
            this.dataGroupMember.getQueryManager().endQuery(requester, queryId);
        }
        catch (StorageEngineException e) {
            throw new TException((Throwable)e);
        }
    }

    public ByteBuffer fetchSingleSeries(RaftNode header, long readerId) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().fetchSingleSeries(readerId);
        }
        catch (IOException | ReaderNotFoundException e) {
            throw new TException((Throwable)e);
        }
    }

    public Map<String, ByteBuffer> fetchMultSeries(RaftNode header, long readerId, List<String> paths) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().fetchMultSeries(readerId, paths);
        }
        catch (IOException | ReaderNotFoundException e) {
            throw new TException((Throwable)e);
        }
    }

    public ByteBuffer fetchSingleSeriesByTimestamps(RaftNode header, long readerId, List<Long> timestamps) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().fetchSingleSeriesByTimestamps(readerId, timestamps.stream().mapToLong(k -> k).toArray(), timestamps.size());
        }
        catch (IOException | ReaderNotFoundException e) {
            throw new TException((Throwable)e);
        }
    }

    public GetAllPathsResult getAllPaths(RaftNode header, List<String> paths, boolean withAlias) throws TException {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            return ((CMManager)IoTDB.metaManager).getAllPaths(paths, withAlias);
        }
        catch (CheckConsistencyException | MetadataException e) {
            throw new TException(e);
        }
    }

    public Set<String> getAllDevices(RaftNode header, List<String> path, boolean isPrefixMatch) throws TException {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            return ((CMManager)IoTDB.metaManager).getAllDevices(path, isPrefixMatch);
        }
        catch (CheckConsistencyException | MetadataException e) {
            throw new TException(e);
        }
    }

    public ByteBuffer getDevices(RaftNode header, ByteBuffer planBinary) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().getDevices(planBinary);
        }
        catch (IOException | CheckConsistencyException | MetadataException e) {
            throw new TException(e);
        }
    }

    public List<String> getNodeList(RaftNode header, String path, int nodeLevel) throws TException {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            return ((CMManager)IoTDB.metaManager).getNodeList(path, nodeLevel);
        }
        catch (CheckConsistencyException | MetadataException e) {
            throw new TException(e);
        }
    }

    public Set<String> getChildNodeInNextLevel(RaftNode header, String path) throws TException {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            return ((CMManager)IoTDB.metaManager).getChildNodeInNextLevel(path);
        }
        catch (CheckConsistencyException | MetadataException e) {
            throw new TException(e);
        }
    }

    public Set<String> getChildNodePathInNextLevel(RaftNode header, String path) throws TException {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            return ((CMManager)IoTDB.metaManager).getChildNodePathInNextLevel(path);
        }
        catch (CheckConsistencyException | MetadataException e) {
            throw new TException(e);
        }
    }

    public ByteBuffer getAllMeasurementSchema(MeasurementSchemaRequest request) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().getAllMeasurementSchema(request);
        }
        catch (IOException | CheckConsistencyException | MetadataException e) {
            throw new TException(e);
        }
    }

    public List<ByteBuffer> getAggrResult(GetAggrResultRequest request) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().getAggrResult(request);
        }
        catch (IOException | StorageEngineException | QueryProcessException | StatisticsClassException | UnSupportedDataTypeException e) {
            throw new TApplicationException(e.getMessage());
        }
    }

    public List<String> getUnregisteredTimeseries(RaftNode header, List<String> timeseriesList) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().getUnregisteredTimeseries(timeseriesList);
        }
        catch (CheckConsistencyException e) {
            throw new TException((Throwable)e);
        }
    }

    public long getGroupByExecutor(GroupByRequest request) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().getGroupByExecutor(request);
        }
        catch (StorageEngineException | QueryProcessException e) {
            throw new TException(e);
        }
    }

    public List<ByteBuffer> getGroupByResult(RaftNode header, long executorId, long startTime, long endTime) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().getGroupByResult(executorId, startTime, endTime);
        }
        catch (IOException | ReaderNotFoundException | QueryProcessException e) {
            throw new TException(e);
        }
    }

    public ByteBuffer previousFill(PreviousFillRequest request) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().previousFill(request);
        }
        catch (IOException | StorageEngineException | IllegalPathException | QueryProcessException e) {
            throw new TException(e);
        }
    }

    public ByteBuffer last(LastQueryRequest request) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().last(request);
        }
        catch (IOException | CheckConsistencyException | StorageEngineException | MetadataException | QueryProcessException e) {
            throw new TException(e);
        }
    }

    public int getPathCount(RaftNode header, List<String> pathsToQuery, int level) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().getPathCount(pathsToQuery, level);
        }
        catch (CheckConsistencyException | MetadataException e) {
            throw new TException(e);
        }
    }

    public int getDeviceCount(RaftNode header, List<String> pathsToQuery) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().getDeviceCount(pathsToQuery);
        }
        catch (CheckConsistencyException | MetadataException e) {
            throw new TException(e);
        }
    }

    public boolean onSnapshotApplied(RaftNode header, List<Integer> slots) {
        return this.dataGroupMember.onSnapshotInstalled(slots);
    }

    public ByteBuffer peekNextNotNullValue(RaftNode header, long executorId, long startTime, long endTime) throws TException {
        try {
            return this.dataGroupMember.getLocalQueryExecutor().peekNextNotNullValue(executorId, startTime, endTime);
        }
        catch (IOException | ReaderNotFoundException e) {
            throw new TException((Throwable)e);
        }
    }
}

