/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.member;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.ClientManager;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.LogExecutionException;
import org.apache.iotdb.cluster.exception.SnapshotInstallationException;
import org.apache.iotdb.cluster.exception.UnknownLogTypeException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.LogApplier;
import org.apache.iotdb.cluster.log.LogParser;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.applier.AsyncDataLogApplier;
import org.apache.iotdb.cluster.log.applier.DataLogApplier;
import org.apache.iotdb.cluster.log.logtypes.AddNodeLog;
import org.apache.iotdb.cluster.log.logtypes.CloseFileLog;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.apache.iotdb.cluster.log.manage.FilePartitionedSnapshotLogManager;
import org.apache.iotdb.cluster.log.manage.PartitionedSnapshotLogManager;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.log.snapshot.FileSnapshot;
import org.apache.iotdb.cluster.log.snapshot.PartitionedSnapshot;
import org.apache.iotdb.cluster.log.snapshot.PullSnapshotTask;
import org.apache.iotdb.cluster.log.snapshot.PullSnapshotTaskDescriptor;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.slot.SlotManager;
import org.apache.iotdb.cluster.partition.slot.SlotNodeAdditionResult;
import org.apache.iotdb.cluster.partition.slot.SlotNodeRemovalResult;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotTimePartitionFilter;
import org.apache.iotdb.cluster.query.LocalQueryExecutor;
import org.apache.iotdb.cluster.query.manage.ClusterQueryManager;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotResp;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.PullSnapshotHintService;
import org.apache.iotdb.cluster.server.heartbeat.DataHeartbeatThread;
import org.apache.iotdb.cluster.server.member.DataGroupMemberMBean;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.server.monitor.NodeReport;
import org.apache.iotdb.cluster.server.monitor.NodeStatusManager;
import org.apache.iotdb.cluster.server.monitor.Peer;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.iotdb.cluster.utils.IOUtils;
import org.apache.iotdb.cluster.utils.StatusUtils;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.VirtualStorageGroupProcessor;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.BatchPlan;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.LogPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGroupMember
extends RaftMember
implements DataGroupMemberMBean {
    private final String mbeanName;
    private static final Logger logger = LoggerFactory.getLogger(DataGroupMember.class);
    private MetaGroupMember metaGroupMember;
    private ExecutorService pullSnapshotService;
    private PullSnapshotHintService pullSnapshotHintService;
    private ClusterQueryManager queryManager;
    protected SlotManager slotManager;
    private LocalQueryExecutor localQueryExecutor;
    LogApplier dataLogApplier;
    private boolean unchanged;
    private LastAppliedPatitionTableVersion lastAppliedPartitionTableVersion;

    public DataGroupMember(PartitionGroup nodes) {
        this.name = "Data-" + nodes.getHeader().getNode().getInternalIp() + "-" + nodes.getHeader().getNode().getDataPort() + "-raftId-" + nodes.getRaftId() + "";
        this.allNodes = nodes;
        this.mbeanName = String.format("%s:%s=%s%d", "org.apache.iotdb.cluster.service", "type", "DataMember", this.getRaftGroupId());
        this.setQueryManager(new ClusterQueryManager());
        this.localQueryExecutor = new LocalQueryExecutor(this);
        this.lastAppliedPartitionTableVersion = new LastAppliedPatitionTableVersion(this.getMemberDir());
    }

    DataGroupMember(TProtocolFactory factory, PartitionGroup nodes, MetaGroupMember metaGroupMember) {
        super("Data-" + nodes.getHeader().getNode().getInternalIp() + "-" + nodes.getHeader().getNode().getDataPort() + "-raftId-" + nodes.getRaftId() + "", new ClientManager(ClusterDescriptor.getInstance().getConfig().isUseAsyncServer(), ClientManager.Type.DataGroupClient));
        this.metaGroupMember = metaGroupMember;
        this.allNodes = nodes;
        this.mbeanName = String.format("%s:%s=%s%d", "org.apache.iotdb.cluster.service", "type", "DataMember", this.getRaftGroupId());
        this.setQueryManager(new ClusterQueryManager());
        this.slotManager = new SlotManager(10000L, this.getMemberDir(), this.getName());
        this.dataLogApplier = new DataLogApplier(metaGroupMember, this);
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncApplier() && ClusterDescriptor.getInstance().getConfig().getReplicationNum() != 1) {
            this.dataLogApplier = new AsyncDataLogApplier(this.dataLogApplier, this.name);
        }
        this.logManager = new FilePartitionedSnapshotLogManager(this.dataLogApplier, metaGroupMember.getPartitionTable(), (Node)this.allNodes.get(0), this.thisNode, this);
        this.initPeerMap();
        this.term.set(this.logManager.getHardState().getCurrentTerm());
        this.voteFor = this.logManager.getHardState().getVoteFor();
        this.localQueryExecutor = new LocalQueryExecutor(this);
        this.lastAppliedPartitionTableVersion = new LastAppliedPatitionTableVersion(this.getMemberDir());
    }

    @Override
    public void start() {
        if (this.heartBeatService != null) {
            return;
        }
        logger.info("Starting DataGroupMember {}... RaftGroupID: {}", (Object)this.name, (Object)this.getRaftGroupId());
        JMXService.registerMBean((Object)this, (String)this.mbeanName);
        super.start();
        this.heartBeatService.submit(new DataHeartbeatThread(this));
        this.pullSnapshotService = IoTDBThreadPoolFactory.newFixedThreadPool((int)Runtime.getRuntime().availableProcessors(), (String)"pullSnapshot");
        this.pullSnapshotHintService = new PullSnapshotHintService(this);
        this.pullSnapshotHintService.start();
        this.resumePullSnapshotTasks();
    }

    @Override
    public void stop() {
        logger.info("Stopping DataGroupMember {}... RaftGroupID: {}", (Object)this.name, (Object)this.getRaftGroupId());
        JMXService.deregisterMBean((String)this.mbeanName);
        super.stop();
        if (this.pullSnapshotService != null) {
            this.pullSnapshotService.shutdownNow();
            try {
                this.pullSnapshotService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for pullSnapshotService to end", (Throwable)e);
            }
            this.pullSnapshotService = null;
            this.pullSnapshotHintService.stop();
        }
        try {
            this.getQueryManager().endAllQueries();
        }
        catch (StorageEngineException e) {
            logger.error("Cannot release queries of {}", (Object)this.name, (Object)e);
        }
        logger.info("{}: stopped", (Object)this.name);
    }

    @Override
    long checkElectorLogProgress(ElectionRequest electionRequest) {
        Node elector = electionRequest.getElector();
        if (!this.allNodes.contains(elector)) {
            logger.info("{}: the elector {} is not in the data group {}, so reject this election.", new Object[]{this.name, this.getPartitionGroup(), elector});
            return -11L;
        }
        return super.checkElectorLogProgress(electionRequest);
    }

    @Override
    public RaftNode getHeader() {
        return this.allNodes.getHeader();
    }

    public ClusterQueryManager getQueryManager() {
        return this.queryManager;
    }

    protected void setQueryManager(ClusterQueryManager queryManager) {
        this.queryManager = queryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preAddNode(Node node) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: start to pre adding node {}", (Object)this.name, (Object)node);
        }
        PartitionGroup partitionGroup = this.allNodes;
        synchronized (partitionGroup) {
            if (this.allNodes.contains(node)) {
                return false;
            }
            int insertIndex = -1;
            for (int i = 0; i < this.allNodes.size() - 1; ++i) {
                Node prev = (Node)this.allNodes.get(i);
                Node next = (Node)this.allNodes.get(i + 1);
                if (!(prev.nodeIdentifier < node.nodeIdentifier && node.nodeIdentifier < next.nodeIdentifier || prev.nodeIdentifier < node.nodeIdentifier && next.nodeIdentifier < prev.nodeIdentifier) && (node.nodeIdentifier >= next.nodeIdentifier || next.nodeIdentifier >= prev.nodeIdentifier)) continue;
                insertIndex = i + 1;
                break;
            }
            if (insertIndex > 0) {
                this.allNodes.add(insertIndex, node);
                this.peerMap.putIfAbsent(node, new Peer(this.logManager.getLastLogIndex()));
                logger.debug("{}: Node {} is inserted into the data group {}", new Object[]{this.name, node, this.allNodes});
            }
            return insertIndex > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(Node node, NodeAdditionResult result) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: start to add node {}", (Object)this.name, (Object)node);
        }
        Set lostSlots = ((SlotNodeAdditionResult)result).getLostSlots().getOrDefault(this.getHeader(), Collections.emptySet());
        for (Integer lostSlot : lostSlots) {
            this.slotManager.setToSending(lostSlot, false);
        }
        this.slotManager.save();
        PartitionGroup partitionGroup = this.allNodes;
        synchronized (partitionGroup) {
            this.preAddNode(node);
            if (this.allNodes.contains(node) && this.allNodes.size() > this.config.getReplicationNum()) {
                Node removedNode = (Node)this.allNodes.remove(this.allNodes.size() - 1);
                this.peerMap.remove(removedNode);
                if (removedNode.equals((Node)this.leader.get()) && !removedNode.equals(this.thisNode)) {
                    Object object = this.term;
                    synchronized (object) {
                        this.setCharacter(NodeCharacter.ELECTOR);
                        this.setLeader(null);
                    }
                    object = this.getHeartBeatWaitObject();
                    synchronized (object) {
                        this.getHeartBeatWaitObject().notifyAll();
                    }
                }
                return removedNode.equals(this.thisNode);
            }
            return false;
        }
    }

    public void receiveSnapshot(SendSnapshotRequest request) throws SnapshotInstallationException {
        logger.info("{}: received a snapshot from {} with size {}", new Object[]{this.name, request.getHeader(), request.getSnapshotBytes().length});
        PartitionedSnapshot<FileSnapshot> snapshot = new PartitionedSnapshot<FileSnapshot>(FileSnapshot.Factory.INSTANCE);
        snapshot.deserialize(ByteBuffer.wrap(request.getSnapshotBytes()));
        if (logger.isDebugEnabled()) {
            logger.debug("{} received a snapshot {}", (Object)this.name, snapshot);
        }
        snapshot.getDefaultInstaller(this).install(snapshot, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PullSnapshotResp getSnapshot(PullSnapshotRequest request) throws IOException {
        if (request.isRequireReadOnly()) {
            this.setReadOnly();
        }
        if (this.character != NodeCharacter.LEADER && this.lastAppliedPartitionTableVersion.getVersion() != this.metaGroupMember.getPartitionTable().getLastMetaLogIndex()) {
            return null;
        }
        List requiredSlots = request.getRequiredSlots();
        for (Integer requiredSlot : requiredSlots) {
            this.slotManager.waitSlot(requiredSlot);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} slots are requested, first:{}, last: {}", new Object[]{this.name, requiredSlots.size(), requiredSlots.get(0), requiredSlots.get(requiredSlots.size() - 1)});
        }
        long currLastLogIndex = this.logManager.getLastLogIndex();
        logger.info("{}: Waiting for logs to commit before snapshot, {}/{}", new Object[]{this.name, this.logManager.getCommitLogIndex(), currLastLogIndex});
        while (this.logManager.getCommitLogIndex() < currLastLogIndex) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("{}: Unexpected interruption when waiting for logs to commit", (Object)this.name, (Object)e);
            }
        }
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            PullSnapshotResp resp = new PullSnapshotResp();
            HashMap<Integer, ByteBuffer> resultMap = new HashMap<Integer, ByteBuffer>();
            ((PartitionedSnapshotLogManager)this.logManager).takeSnapshotForSpecificSlots(requiredSlots, false);
            PartitionedSnapshot allSnapshot = (PartitionedSnapshot)this.logManager.getSnapshot();
            Iterator iterator = requiredSlots.iterator();
            while (iterator.hasNext()) {
                int requiredSlot = (Integer)iterator.next();
                Object snapshot = allSnapshot.getSnapshot(requiredSlot);
                if (snapshot == null) continue;
                resultMap.put(requiredSlot, ((Snapshot)snapshot).serialize());
            }
            resp.setSnapshotBytes(resultMap);
            logger.debug("{}: Sending {} snapshots to the requester", (Object)this.name, (Object)resultMap.size());
            return resp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullNodeAdditionSnapshots(List<Integer> slots, Node newNode) {
        HashMap<PartitionGroup, List> holderSlotsMap = new HashMap<PartitionGroup, List>();
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            logger.info("{} pulling {} slots from remote", (Object)this.name, (Object)slots.size());
            PartitionedSnapshot partitionedSnapshot = (PartitionedSnapshot)this.logManager.getSnapshot();
            Map<Integer, PartitionGroup> prevHolders = ((SlotPartitionTable)this.metaGroupMember.getPartitionTable()).getPreviousNodeMap(new RaftNode(newNode, this.getRaftGroupId()));
            for (int slot : slots) {
                PartitionGroup group;
                if (partitionedSnapshot.getSnapshot(slot) != null || (group = prevHolders.get(slot)) == null) continue;
                holderSlotsMap.computeIfAbsent(group, n -> new ArrayList()).add(slot);
            }
        }
        for (Map.Entry entry : holderSlotsMap.entrySet()) {
            List nodeSlots = (List)entry.getValue();
            PullSnapshotTaskDescriptor taskDescriptor = new PullSnapshotTaskDescriptor((PartitionGroup)entry.getKey(), nodeSlots, false);
            this.pullFileSnapshot(taskDescriptor, null);
        }
    }

    private void pullFileSnapshot(PullSnapshotTaskDescriptor descriptor, File snapshotSave) {
        if (descriptor.getPreviousHolders().contains(this.thisNode)) {
            logger.info("{}: {} and other {} don't need to pull because there already has such data locally", new Object[]{this.name, descriptor.getSlots().get(0), descriptor.getSlots().size() - 1});
            this.registerPullSnapshotHint(descriptor);
            return;
        }
        Iterator<Integer> iterator = descriptor.getSlots().iterator();
        while (iterator.hasNext()) {
            Integer nodeSlot = iterator.next();
            SlotManager.SlotStatus status = this.slotManager.getStatus(nodeSlot);
            if (status != SlotManager.SlotStatus.NULL) {
                iterator.remove();
                continue;
            }
            this.slotManager.setToPulling(nodeSlot, descriptor.getPreviousHolders().getHeader().getNode(), false);
        }
        this.slotManager.save();
        if (descriptor.getSlots().isEmpty()) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("{}: {} and other {} slots are set to pulling", new Object[]{this.name, descriptor.getSlots().get(0), descriptor.getSlots().size() - 1});
        }
        this.pullSnapshotService.submit(new PullSnapshotTask<FileSnapshot>(descriptor, this, FileSnapshot.Factory.INSTANCE, snapshotSave));
    }

    private void resumePullSnapshotTasks() {
        File snapshotTaskDir = new File(this.getPullSnapshotTaskDir());
        if (!snapshotTaskDir.exists()) {
            return;
        }
        File[] files = snapshotTaskDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith(".task")) continue;
                try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                    PullSnapshotTaskDescriptor descriptor = new PullSnapshotTaskDescriptor();
                    descriptor.deserialize(dataInputStream);
                    this.pullFileSnapshot(descriptor, file);
                }
                catch (IOException e) {
                    logger.error("Cannot resume pull-snapshot-task in file {}", (Object)file, (Object)e);
                    try {
                        Files.delete(file.toPath());
                    }
                    catch (IOException ex) {
                        logger.debug("Cannot remove pull snapshot task file {}", (Object)file, (Object)e);
                    }
                }
            }
        }
    }

    public String getPullSnapshotTaskDir() {
        return this.getMemberDir() + "snapshot_task" + File.separator;
    }

    private String getMemberDir() {
        return IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "raft" + File.separator + this.getHeader().getNode().nodeIdentifier + File.separator + this.getRaftGroupId() + File.separator;
    }

    public MetaGroupMember getMetaGroupMember() {
        return this.metaGroupMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closePartition(String storageGroupName, long partitionId, boolean isSeq) {
        if (this.character != NodeCharacter.LEADER) {
            return false;
        }
        CloseFileLog log = new CloseFileLog(storageGroupName, partitionId, isSeq);
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            log.setCurrLogTerm(this.getTerm().get());
            log.setCurrLogIndex(this.logManager.getLastLogIndex() + 1L);
            this.logManager.append(log);
            logger.info("Send the close file request of {} to other nodes", (Object)log);
        }
        try {
            return this.appendLogInGroup(log);
        }
        catch (LogExecutionException e) {
            logger.error("Cannot close partition {}#{} seq:{}", new Object[]{storageGroupName, partitionId, isSeq, e});
            return false;
        }
    }

    public boolean flushFileWhenDoSnapshot(Map<String, List<Pair<Long, Boolean>>> storageGroupPartitions, List<Integer> requiredSlots, boolean needLeader) {
        if (needLeader && this.character != NodeCharacter.LEADER) {
            return false;
        }
        HashMap localDataMemberStorageGroupPartitions = new HashMap();
        for (Map.Entry<String, List<Pair<Long, Boolean>>> entry : storageGroupPartitions.entrySet()) {
            ArrayList<Pair<Long, Boolean>> localListPair = new ArrayList<Pair<Long, Boolean>>();
            String storageGroupName = entry.getKey();
            List<Pair<Long, Boolean>> tmpPairList = entry.getValue();
            for (Pair<Long, Boolean> pair : tmpPairList) {
                long timestamp = (Long)pair.left * StorageEngine.getTimePartitionInterval();
                int slotId = SlotPartitionTable.getSlotStrategy().calculateSlotByTime(storageGroupName, timestamp, 10000);
                if (!requiredSlots.contains(slotId)) continue;
                localListPair.add(pair);
            }
            try {
                localDataMemberStorageGroupPartitions.put(new PartialPath(storageGroupName), localListPair);
            }
            catch (IllegalPathException illegalPathException) {}
        }
        if (localDataMemberStorageGroupPartitions.size() <= 0) {
            logger.info("{}: have no data to flush", (Object)this.name);
            return true;
        }
        FlushPlan flushPlan = new FlushPlan(null, true, localDataMemberStorageGroupPartitions);
        try {
            PlanExecutor.flushSpecifiedStorageGroups((FlushPlan)flushPlan);
            return true;
        }
        catch (StorageGroupNotSetException e) {
            logger.error("Some SGs are missing while flushing", (Throwable)e);
            return false;
        }
    }

    @Override
    public TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        if (ClusterDescriptor.getInstance().getConfig().getReplicationNum() == 1) {
            try {
                if (plan instanceof LogPlan) {
                    Log log;
                    try {
                        log = LogParser.getINSTANCE().parse(((LogPlan)plan).getLog());
                    }
                    catch (UnknownLogTypeException e) {
                        logger.error("Can not parse LogPlan {}", (Object)plan, (Object)e);
                        return StatusUtils.PARSE_LOG_ERROR;
                    }
                    this.handleChangeMembershipLogWithoutRaft(log);
                } else {
                    ((DataLogApplier)this.dataLogApplier).applyPhysicalPlan(plan);
                }
                return StatusUtils.OK;
            }
            catch (Exception e) {
                boolean hasCreated;
                Throwable cause;
                block14: {
                    cause = IOUtils.getRootCause(e);
                    hasCreated = false;
                    try {
                        if (!(plan instanceof InsertPlan) || !ClusterDescriptor.getInstance().getConfig().isEnableAutoCreateSchema()) break block14;
                        if (plan instanceof InsertRowsPlan || plan instanceof InsertMultiTabletPlan) {
                            if (!(e instanceof BatchProcessException)) break block14;
                            for (TSStatus status : ((BatchProcessException)((Object)e)).getFailingStatus()) {
                                if (status.getCode() != TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode()) continue;
                                hasCreated = this.createTimeseriesForFailedInsertion((InsertPlan)plan);
                                ((BatchPlan)plan).getResults().clear();
                                break block14;
                            }
                            break block14;
                        }
                        if (cause instanceof PathNotExistException) {
                            hasCreated = this.createTimeseriesForFailedInsertion((InsertPlan)plan);
                        }
                    }
                    catch (CheckConsistencyException | MetadataException ex) {
                        logger.error("{}: Cannot auto-create timeseries for {}", new Object[]{this.name, plan, e});
                        return StatusUtils.getStatus(StatusUtils.EXECUTE_STATEMENT_ERROR, ex.getMessage());
                    }
                }
                if (hasCreated) {
                    return this.executeNonQueryPlan(plan);
                }
                return this.handleLogExecutionException(plan, cause);
            }
        }
        TSStatus status = this.executeNonQueryPlanWithKnownLeader(plan);
        if (!StatusUtils.NO_LEADER.equals(status)) {
            return status;
        }
        long startTime = Timer.Statistic.DATA_GROUP_MEMBER_WAIT_LEADER.getOperationStartTime();
        this.waitLeader();
        Timer.Statistic.DATA_GROUP_MEMBER_WAIT_LEADER.calOperationCostTimeFromStart(startTime);
        return this.executeNonQueryPlanWithKnownLeader(plan);
    }

    @Override
    ClientCategory getClientCategory() {
        return ClientCategory.DATA;
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    private void handleChangeMembershipLogWithoutRaft(Log log) {
        if (log instanceof AddNodeLog) {
            if (!this.metaGroupMember.getPartitionTable().deserialize(((AddNodeLog)log).getPartitionTable())) {
                return;
            }
            this.preAddNode(((AddNodeLog)log).getNewNode());
            this.setAndSaveLastAppliedPartitionTableVersion(((AddNodeLog)log).getMetaLogIndex());
        } else if (log instanceof RemoveNodeLog) {
            if (!this.metaGroupMember.getPartitionTable().deserialize(((RemoveNodeLog)log).getPartitionTable())) {
                return;
            }
            this.preRemoveNode(((RemoveNodeLog)log).getRemovedNode());
            this.setAndSaveLastAppliedPartitionTableVersion(((RemoveNodeLog)log).getMetaLogIndex());
        } else {
            logger.error("Unsupported log: {}", (Object)log);
        }
    }

    private TSStatus executeNonQueryPlanWithKnownLeader(PhysicalPlan plan) {
        if (this.character == NodeCharacter.LEADER) {
            boolean hasCreated;
            TSStatus status;
            long startTime;
            block11: {
                startTime = Timer.Statistic.DATA_GROUP_MEMBER_LOCAL_EXECUTION.getOperationStartTime();
                status = this.processPlanLocally(plan);
                hasCreated = false;
                try {
                    if (!(plan instanceof InsertPlan) || !ClusterDescriptor.getInstance().getConfig().isEnableAutoCreateSchema()) break block11;
                    if (plan instanceof InsertRowsPlan || plan instanceof InsertMultiTabletPlan) {
                        if (status.getCode() != TSStatusCode.MULTIPLE_ERROR.getStatusCode()) break block11;
                        for (TSStatus tmpStatus : status.getSubStatus()) {
                            if (tmpStatus.getCode() != TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode()) continue;
                            hasCreated = this.createTimeseriesForFailedInsertion((InsertPlan)plan);
                            ((BatchPlan)plan).getResults().clear();
                            break block11;
                        }
                        break block11;
                    }
                    if (status.getCode() == TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode()) {
                        hasCreated = this.createTimeseriesForFailedInsertion((InsertPlan)plan);
                    }
                }
                catch (CheckConsistencyException | MetadataException e) {
                    logger.error("{}: Cannot auto-create timeseries for {}", new Object[]{this.name, plan, e});
                    return StatusUtils.getStatus(StatusUtils.EXECUTE_STATEMENT_ERROR, e.getMessage());
                }
            }
            if (hasCreated) {
                status = this.processPlanLocally(plan);
            }
            Timer.Statistic.DATA_GROUP_MEMBER_LOCAL_EXECUTION.calOperationCostTimeFromStart(startTime);
            if (status != null) {
                return status;
            }
        } else if (this.leader.get() != null && !ClusterConstant.EMPTY_NODE.equals((Node)this.leader.get())) {
            long startTime = Timer.Statistic.DATA_GROUP_MEMBER_FORWARD_PLAN.getOperationStartTime();
            TSStatus result = this.forwardPlan(plan, (Node)this.leader.get(), this.getHeader());
            Timer.Statistic.DATA_GROUP_MEMBER_FORWARD_PLAN.calOperationCostTimeFromStart(startTime);
            if (!StatusUtils.NO_LEADER.equals(result)) {
                result.setRedirectNode(new EndPoint(((Node)this.leader.get()).getClientIp(), ((Node)this.leader.get()).getClientPort()));
                return result;
            }
        }
        return StatusUtils.NO_LEADER;
    }

    private boolean createTimeseriesForFailedInsertion(InsertPlan plan) throws CheckConsistencyException, IllegalPathException {
        logger.debug("create time series for failed insertion {}", (Object)plan);
        if (plan instanceof InsertMultiTabletPlan) {
            for (InsertTabletPlan insertPlan : ((InsertMultiTabletPlan)plan).getInsertTabletPlanList()) {
                if (insertPlan.getFailedMeasurements() == null) continue;
                insertPlan.getPlanFromFailed();
            }
        }
        if (plan instanceof InsertRowsPlan) {
            for (InsertTabletPlan insertPlan : ((InsertRowsPlan)plan).getInsertRowPlanList()) {
                if (insertPlan.getFailedMeasurements() == null) continue;
                insertPlan.getPlanFromFailed();
            }
        }
        if (plan instanceof InsertRowsOfOneDevicePlan) {
            for (InsertRowPlan insertPlan : ((InsertRowsOfOneDevicePlan)plan).getRowPlans()) {
                if (insertPlan.getFailedMeasurements() == null) continue;
                insertPlan.getPlanFromFailed();
            }
        }
        if (plan.getFailedMeasurements() != null) {
            plan.getPlanFromFailed();
        }
        return ((CMManager)IoTDB.metaManager).createTimeseries(plan);
    }

    public void removeLocalData(List<Integer> slots) {
        if (slots.isEmpty()) {
            return;
        }
        HashSet<Integer> slotSet = new HashSet<Integer>(slots);
        List allStorageGroupNames = IoTDB.metaManager.getAllStorageGroupPaths();
        VirtualStorageGroupProcessor.TimePartitionFilter filter = (storageGroupName, timePartitionId) -> {
            int slot = SlotPartitionTable.getSlotStrategy().calculateSlotByPartitionNum(storageGroupName, timePartitionId, 10000);
            if (((SlotPartitionTable)this.metaGroupMember.getPartitionTable()).judgeHoldSlot(this.thisNode, slot)) {
                return false;
            }
            return slotSet.contains(slot);
        };
        for (PartialPath sg : allStorageGroupNames) {
            StorageEngine.getInstance().removePartitions(sg, filter);
        }
        for (Integer slot : slots) {
            this.slotManager.setToNull(slot, false);
        }
        this.slotManager.save();
        if (logger.isInfoEnabled()) {
            logger.info("{}: data of {} and other {} slots are removed", new Object[]{this.name, slots.get(0), slots.size() - 1});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRemoveNode(Node removedNode) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: start to pre remove node {}", (Object)this.name, (Object)removedNode);
        }
        PartitionGroup partitionGroup = this.allNodes;
        synchronized (partitionGroup) {
            if (this.allNodes.contains(removedNode) && this.allNodes.size() == this.config.getReplicationNum()) {
                PartitionGroup newGroup = this.metaGroupMember.getPartitionTable().getPartitionGroup(this.getHeader());
                if (newGroup == null) {
                    return;
                }
                Node newNodeToGroup = (Node)newGroup.get(newGroup.size() - 1);
                this.allNodes.add(newNodeToGroup);
                this.peerMap.putIfAbsent(newNodeToGroup, new Peer(this.logManager.getLastLogIndex()));
            }
        }
    }

    public VirtualStorageGroupProcessor.TimePartitionFilter getTimePartitionFilter() {
        HashSet<Integer> slotSet = new HashSet<Integer>(((SlotPartitionTable)this.metaGroupMember.getPartitionTable()).getNodeSlots(this.getHeader()));
        return new SlotTimePartitionFilter(slotSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node removedNode) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: start to remove node {}", (Object)this.name, (Object)removedNode);
        }
        PartitionGroup partitionGroup = this.allNodes;
        synchronized (partitionGroup) {
            this.preRemoveNode(removedNode);
            if (this.allNodes.contains(removedNode)) {
                this.allNodes.remove(removedNode);
                this.peerMap.remove(removedNode);
                if (removedNode.equals((Node)this.leader.get())) {
                    Object object = this.term;
                    synchronized (object) {
                        this.setCharacter(NodeCharacter.ELECTOR);
                        this.setLeader(null);
                    }
                    object = this.getHeartBeatWaitObject();
                    synchronized (object) {
                        this.getHeartBeatWaitObject().notifyAll();
                    }
                }
            }
        }
    }

    public void pullSlots(NodeRemovalResult removalResult) {
        List<Integer> slotsToPull = ((SlotNodeRemovalResult)removalResult).getNewSlotOwners().get(this.getHeader());
        if (slotsToPull != null) {
            PullSnapshotTaskDescriptor taskDescriptor = new PullSnapshotTaskDescriptor(removalResult.getRemovedGroup(this.getRaftGroupId()), new ArrayList<Integer>(slotsToPull), true);
            this.pullFileSnapshot(taskDescriptor, null);
        }
    }

    public NodeReport.DataMemberReport genReport() {
        long prevLastLogIndex = this.lastReportedLogIndex;
        this.lastReportedLogIndex = this.logManager.getLastLogIndex();
        return new NodeReport.DataMemberReport(this.character, (Node)this.leader.get(), this.term.get(), this.logManager.getLastLogTerm(), this.lastReportedLogIndex, this.logManager.getCommitLogIndex(), this.logManager.getCommitLogTerm(), this.getHeader(), this.readOnly, NodeStatusManager.getINSTANCE().getLastResponseLatency(this.getHeader().getNode()), this.lastHeartbeatReceivedTime, prevLastLogIndex, this.logManager.getMaxHaveAppliedCommitIndex());
    }

    public void setMetaGroupMember(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
        this.localQueryExecutor = new LocalQueryExecutor(this);
    }

    void setLogManager(PartitionedSnapshotLogManager<Snapshot> logManager) {
        if (this.logManager != null) {
            this.logManager.close();
        }
        this.logManager = logManager;
        super.setLogManager(logManager);
        this.initPeerMap();
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public boolean onSnapshotInstalled(List<Integer> slots) {
        if (this.getMetaGroupMember().getPartitionTable().getAllNodes().contains(this.thisNode)) {
            this.getMetaGroupMember().syncLocalApply(this.getMetaGroupMember().getPartitionTable().getLastMetaLogIndex(), false);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} received one replication snapshot installed of slot {} and other {} slots", new Object[]{this.name, slots.get(0), slots.size() - 1});
        }
        ArrayList<Integer> removableSlots = new ArrayList<Integer>();
        for (Integer slot : slots) {
            int sentReplicaNum = this.slotManager.sentOneReplication(slot, false);
            if (sentReplicaNum < this.config.getReplicationNum()) continue;
            removableSlots.add(slot);
        }
        this.slotManager.save();
        this.removeLocalData(removableSlots);
        return true;
    }

    public void registerPullSnapshotHint(PullSnapshotTaskDescriptor descriptor) {
        this.pullSnapshotHintService.registerHint(descriptor);
    }

    public Map<PartitionGroup, Set<Integer>> getPreviousHolderSlotMap() {
        HashMap<PartitionGroup, Set<Integer>> holderSlotMap = new HashMap<PartitionGroup, Set<Integer>>();
        RaftNode header = this.getHeader();
        Map<RaftNode, Map<Integer, PartitionGroup>> previousHolderMap = ((SlotPartitionTable)this.getMetaGroupMember().getPartitionTable()).getPreviousNodeMap();
        if (previousHolderMap.containsKey(header)) {
            for (Map.Entry<Integer, PartitionGroup> entry : previousHolderMap.get(header).entrySet()) {
                int slot = entry.getKey();
                PartitionGroup holder = entry.getValue();
                if (!this.slotManager.checkSlotInDataMigrationStatus(slot)) continue;
                holderSlotMap.computeIfAbsent(holder, n -> new HashSet()).add(slot);
            }
        }
        return holderSlotMap;
    }

    public LocalQueryExecutor getLocalQueryExecutor() {
        return this.localQueryExecutor;
    }

    public void setLocalQueryExecutor(LocalQueryExecutor localQueryExecutor) {
        this.localQueryExecutor = localQueryExecutor;
    }

    public boolean isUnchanged() {
        return this.unchanged;
    }

    public void setUnchanged(boolean unchanged) {
        this.unchanged = unchanged;
    }

    public void setAndSaveLastAppliedPartitionTableVersion(long version) {
        this.lastAppliedPartitionTableVersion.setVersion(version);
        this.lastAppliedPartitionTableVersion.save();
    }

    private class LastAppliedPatitionTableVersion {
        private static final String VERSION_FILE_NAME = "LAST_PARTITION_TABLE_VERSION";
        private long version = -1L;
        private String filePath;

        public LastAppliedPatitionTableVersion(String memberDir) {
            this.filePath = memberDir + File.separator + VERSION_FILE_NAME;
            this.load();
        }

        private void load() {
            File versionFile = new File(this.filePath);
            if (!versionFile.exists()) {
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(this.filePath);
                 DataInputStream dataInputStream = new DataInputStream(fileInputStream);){
                this.version = dataInputStream.readLong();
            }
            catch (Exception e) {
                logger.warn("Cannot deserialize last partition table version from {}", (Object)this.filePath, (Object)e);
            }
        }

        public synchronized void save() {
            File versionFile = new File(this.filePath);
            if (!versionFile.getParentFile().exists() && !versionFile.getParentFile().mkdirs()) {
                logger.warn("Cannot mkdirs for {}", (Object)versionFile);
            }
            try (FileOutputStream outputStream = new FileOutputStream(versionFile);
                 DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
                dataOutputStream.writeLong(this.version);
            }
            catch (IOException e) {
                logger.warn("Last partition table version in {} cannot be saved", (Object)this.filePath, (Object)e);
            }
        }

        public long getVersion() {
            return this.version;
        }

        public void setVersion(long version) {
            this.version = version;
        }
    }

    public static class Factory {
        private TProtocolFactory protocolFactory;
        private MetaGroupMember metaGroupMember;

        public Factory(TProtocolFactory protocolFactory, MetaGroupMember metaGroupMember) {
            this.protocolFactory = protocolFactory;
            this.metaGroupMember = metaGroupMember;
        }

        public DataGroupMember create(PartitionGroup partitionGroup) {
            return new DataGroupMember(this.protocolFactory, partitionGroup, this.metaGroupMember);
        }
    }
}

