/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.rpc.thrift.AddNodeResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinClusterHandler
implements AsyncMethodCallback<AddNodeResponse> {
    private static final Logger logger = LoggerFactory.getLogger(JoinClusterHandler.class);
    private Node contact;
    private AtomicReference<AddNodeResponse> response;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(AddNodeResponse resp) {
        logger.info("Received a join cluster response {} from {}", (Object)resp.getRespNum(), (Object)this.contact);
        AtomicReference<AddNodeResponse> atomicReference = this.response;
        synchronized (atomicReference) {
            this.response.set(resp);
            this.response.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        logger.warn("Cannot join the cluster from {}, because", (Object)this.contact, (Object)exception);
        AtomicReference<AddNodeResponse> atomicReference = this.response;
        synchronized (atomicReference) {
            this.response.notifyAll();
        }
    }

    public void setResponse(AtomicReference<AddNodeResponse> response) {
        this.response = response;
    }

    public void setContact(Node contact) {
        this.contact = contact;
    }
}

