/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConsistencyLevel {
    STRONG_CONSISTENCY("strong"),
    MID_CONSISTENCY("mid"),
    WEAK_CONSISTENCY("weak");

    private String consistencyLevelName;
    private static final Logger logger;

    private ConsistencyLevel(String consistencyLevelName) {
        this.consistencyLevelName = consistencyLevelName;
    }

    public static ConsistencyLevel getConsistencyLevel(String consistencyLevel) {
        if (consistencyLevel == null) {
            return MID_CONSISTENCY;
        }
        switch (consistencyLevel.toLowerCase()) {
            case "strong": {
                return STRONG_CONSISTENCY;
            }
            case "mid": {
                return MID_CONSISTENCY;
            }
            case "weak": {
                return WEAK_CONSISTENCY;
            }
        }
        logger.warn("Unsupported consistency level={}, use default consistency level={}", (Object)consistencyLevel, (Object)ConsistencyLevel.MID_CONSISTENCY.consistencyLevelName);
        return MID_CONSISTENCY;
    }

    static {
        logger = LoggerFactory.getLogger(ConsistencyLevel.class);
    }
}

