/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class DoubleTVList
extends TVList {
    private List<double[]> values = new ArrayList<double[]>();
    private double[][] sortedValues;
    private double pivotValue;

    DoubleTVList() {
    }

    @Override
    public void putDouble(long timestamp, double value) {
        this.checkExpansion();
        int arrayIndex = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
        this.minTime = Math.min(this.minTime, timestamp);
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        ++this.rowCount;
        if (this.sorted && this.rowCount > 1 && timestamp < this.getTime(this.rowCount - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public double getDouble(int index) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        return this.values.get(arrayIndex)[elementIndex];
    }

    protected void set(int index, long timestamp, double value) {
        if (index >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / PrimitiveArrayManager.ARRAY_SIZE;
        int elementIndex = index % PrimitiveArrayManager.ARRAY_SIZE;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    public DoubleTVList clone() {
        DoubleTVList cloneList = new DoubleTVList();
        this.cloneAs(cloneList);
        for (double[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private double[] cloneValue(double[] array) {
        double[] cloneArray = new double[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public void sort() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < PrimitiveArrayManager.getArrayRowCount(this.rowCount)) {
            this.sortedTimestamps = (long[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT64, this.rowCount);
        }
        if (this.sortedValues == null || this.sortedValues.length < PrimitiveArrayManager.getArrayRowCount(this.rowCount)) {
            this.sortedValues = (double[][])PrimitiveArrayManager.createDataListsByType(TSDataType.DOUBLE, this.rowCount);
        }
        this.sort(0, this.rowCount);
        this.clearSortedValue();
        this.clearSortedTime();
        this.sorted = true;
    }

    @Override
    void clearValue() {
        if (this.values != null) {
            for (double[] dataArray : this.values) {
                PrimitiveArrayManager.release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    void clearSortedValue() {
        if (this.sortedValues != null) {
            this.sortedValues = null;
        }
    }

    @Override
    protected void setFromSorted(int src, int dest) {
        this.set(dest, this.sortedTimestamps[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE], this.sortedValues[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    @Override
    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        double srcV = this.getDouble(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    protected void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getTime(src);
        this.sortedValues[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.getDouble(src);
    }

    @Override
    protected void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.getTime(lo);
            double loV = this.getDouble(lo);
            long hiT = this.getTime(hi);
            double hiV = this.getDouble(hi);
            this.set(lo++, hiT, hiV);
            this.set(hi--, loT, loV);
        }
    }

    @Override
    protected void expandValues() {
        this.values.add((double[])this.getPrimitiveArraysByType(TSDataType.DOUBLE));
    }

    @Override
    protected void saveAsPivot(int pos) {
        this.pivotTime = this.getTime(pos);
        this.pivotValue = this.getDouble(pos);
    }

    @Override
    protected void setPivotTo(int pos) {
        this.set(pos, this.pivotTime, this.pivotValue);
    }

    @Override
    public TimeValuePair getTimeValuePair(int index) {
        return new TimeValuePair(this.getTime(index), TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)this.getDouble(index)));
    }

    @Override
    protected TimeValuePair getTimeValuePair(int index, long time, Integer floatPrecision, TSEncoding encoding) {
        double value = this.getDouble(index);
        if (!(Double.isNaN(value) || encoding != TSEncoding.RLE && encoding != TSEncoding.TS_2DIFF)) {
            value = MathUtils.roundWithGivenPrecision(value, (int)floatPrecision);
        }
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)value));
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayManager.release(this.values.remove(this.values.size() - 1));
    }

    @Override
    public void putDoubles(long[] time, double[] value, BitMap bitMap, int start, int end) {
        this.checkExpansion();
        int idx = start;
        int timeIdxOffset = 0;
        if (bitMap != null && !bitMap.isAllUnmarked()) {
            long[] clonedTime = new long[end - start];
            System.arraycopy(time, start, clonedTime, 0, end - start);
            time = clonedTime;
            timeIdxOffset = start;
            int nullCnt = this.dropNullValThenUpdateMinTimeAndSorted(time, value, bitMap, start, end, timeIdxOffset);
            end -= nullCnt;
        } else {
            this.updateMinTimeAndSorted(time, start, end);
        }
        while (idx < end) {
            int inputRemaining = end - idx;
            int arrayIdx = this.rowCount / PrimitiveArrayManager.ARRAY_SIZE;
            int elementIdx = this.rowCount % PrimitiveArrayManager.ARRAY_SIZE;
            int internalRemaining = PrimitiveArrayManager.ARRAY_SIZE - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                this.rowCount += inputRemaining;
                break;
            }
            System.arraycopy(time, idx - timeIdxOffset, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            idx += internalRemaining;
            this.rowCount += internalRemaining;
            this.checkExpansion();
        }
    }

    int dropNullValThenUpdateMinTimeAndSorted(long[] time, double[] values, BitMap bitMap, int start, int end, int tIdxOffset) {
        long inPutMinTime = Long.MAX_VALUE;
        boolean inputSorted = true;
        int nullCnt = 0;
        for (int vIdx = start; vIdx < end; ++vIdx) {
            if (bitMap.isMarked(vIdx)) {
                ++nullCnt;
                continue;
            }
            int tIdx = vIdx - tIdxOffset;
            if (nullCnt != 0) {
                time[tIdx - nullCnt] = time[tIdx];
                values[vIdx - nullCnt] = values[vIdx];
            }
            inPutMinTime = Math.min(inPutMinTime, time[tIdx -= nullCnt]);
            if (!inputSorted || tIdx <= 0 || time[tIdx - 1] <= time[tIdx]) continue;
            inputSorted = false;
        }
        this.minTime = Math.min(inPutMinTime, this.minTime);
        this.sorted = this.sorted && inputSorted && (this.rowCount == 0 || inPutMinTime >= this.getTime(this.rowCount - 1));
        return nullCnt;
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.DOUBLE;
    }
}

