/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.manage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;
import org.apache.iotdb.db.sync.sender.manage.ISyncFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFileManager
implements ISyncFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncFileManager.class);
    private Map<String, Map<Long, Set<Long>>> allSGs;
    private Map<String, Map<Long, Map<Long, Set<File>>>> currentSealedLocalFilesMap;
    private Map<String, Map<Long, Map<Long, Set<File>>>> lastLocalFilesMap;
    private Map<String, Map<Long, Map<Long, Set<File>>>> deletedFilesMap;
    private Map<String, Map<Long, Map<Long, Set<File>>>> toBeSyncedFilesMap;

    private SyncFileManager() {
        IoTDB.metaManager.init();
    }

    public static SyncFileManager getInstance() {
        return SyncFileManagerHolder.INSTANCE;
    }

    @Override
    public void getCurrentLocalFiles(String dataDir) {
        LOGGER.info("Start to get current local files in data folder {}", (Object)dataDir);
        this.currentSealedLocalFilesMap = new HashMap<String, Map<Long, Map<Long, Set<File>>>>();
        HashMap currentAllLocalFiles = new HashMap();
        if (!new File(dataDir + File.separatorChar + "sequence").exists()) {
            return;
        }
        File[] allSgFolders = new File(dataDir + File.separatorChar + "sequence").listFiles();
        for (File sgFolder : allSgFolders) {
            if (!sgFolder.getName().startsWith("root") || sgFolder.getName().equals("tmp")) continue;
            this.allSGs.putIfAbsent(sgFolder.getName(), new HashMap());
            currentAllLocalFiles.putIfAbsent(sgFolder.getName(), new HashMap());
            for (File virtualSgFolder : sgFolder.listFiles()) {
                try {
                    Long vgId = Long.parseLong(virtualSgFolder.getName());
                    this.allSGs.get(sgFolder.getName()).putIfAbsent(vgId, new HashSet());
                    ((Map)currentAllLocalFiles.get(sgFolder.getName())).putIfAbsent(vgId, new HashMap());
                    for (File timeRangeFolder : virtualSgFolder.listFiles()) {
                        Long timeRangeId = Long.parseLong(timeRangeFolder.getName());
                        ((Map)((Map)currentAllLocalFiles.get(sgFolder.getName())).get(vgId)).putIfAbsent(timeRangeId, new HashSet());
                        File[] files = timeRangeFolder.listFiles();
                        Arrays.stream(files).forEach(file -> ((Set)((Map)((Map)currentAllLocalFiles.get(sgFolder.getName())).get(vgId)).get(timeRangeId)).add(new File(timeRangeFolder.getAbsolutePath(), file.getName())));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Invalid virtual storage group folder: {}", (Object)virtualSgFolder.getAbsolutePath(), (Object)e);
                }
            }
        }
        for (Map.Entry entry : currentAllLocalFiles.entrySet()) {
            String sgName = (String)entry.getKey();
            this.currentSealedLocalFilesMap.putIfAbsent(sgName, new HashMap());
            for (Map.Entry vgEntry : ((Map)entry.getValue()).entrySet()) {
                Long vgId = (Long)vgEntry.getKey();
                this.currentSealedLocalFilesMap.get(sgName).putIfAbsent(vgId, new HashMap());
                for (Map.Entry innerEntry : ((Map)vgEntry.getValue()).entrySet()) {
                    Long timeRangeId = (Long)innerEntry.getKey();
                    this.currentSealedLocalFilesMap.get(sgName).get(vgId).putIfAbsent(timeRangeId, new HashSet());
                    for (File file2 : (Set)innerEntry.getValue()) {
                        if (!file2.getName().endsWith(".tsfile") || !this.checkFileValidity(file2)) continue;
                        this.currentSealedLocalFilesMap.get(sgName).get(vgId).get(timeRangeId).add(file2);
                    }
                }
            }
        }
    }

    private boolean checkFileValidity(File file) {
        return new File(file.getAbsolutePath() + ".resource").exists() && !new File(file.getAbsolutePath() + ".mods").exists() && !new File(file.getAbsolutePath() + ".cross").exists();
    }

    @Override
    public void getLastLocalFiles(File lastLocalFileInfo) throws IOException {
        LOGGER.info("Start to get last local files from last local file info {}", (Object)lastLocalFileInfo.getAbsoluteFile());
        this.lastLocalFilesMap = new HashMap<String, Map<Long, Map<Long, Set<File>>>>();
        if (!lastLocalFileInfo.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(lastLocalFileInfo));){
            String filePath;
            while ((filePath = reader.readLine()) != null) {
                File file = new File(filePath);
                Long timeRangeId = Long.parseLong(file.getParentFile().getName());
                Long vgId = Long.parseLong(file.getParentFile().getParentFile().getName());
                String sgName = file.getParentFile().getParentFile().getParentFile().getName();
                this.allSGs.putIfAbsent(sgName, new HashMap());
                this.allSGs.get(sgName).putIfAbsent(vgId, new HashSet());
                this.lastLocalFilesMap.computeIfAbsent(sgName, k -> new HashMap()).computeIfAbsent(vgId, k -> new HashMap()).computeIfAbsent(timeRangeId, k -> new HashSet()).add(file);
            }
        }
    }

    @Override
    public void getValidFiles(String dataDir) throws IOException {
        this.allSGs = new HashMap<String, Map<Long, Set<Long>>>();
        this.getCurrentLocalFiles(dataDir);
        this.getLastLocalFiles(new File(SyncSenderDescriptor.getInstance().getConfig().getLastFileInfoPath()));
        this.toBeSyncedFilesMap = new HashMap<String, Map<Long, Map<Long, Set<File>>>>();
        this.deletedFilesMap = new HashMap<String, Map<Long, Map<Long, Set<File>>>>();
        for (String sgName : this.allSGs.keySet()) {
            Long timeRangeId;
            Long vgId;
            this.toBeSyncedFilesMap.putIfAbsent(sgName, new HashMap());
            this.deletedFilesMap.putIfAbsent(sgName, new HashMap());
            for (Map.Entry entry : this.currentSealedLocalFilesMap.getOrDefault(sgName, Collections.emptyMap()).entrySet()) {
                vgId = (Long)entry.getKey();
                this.toBeSyncedFilesMap.get(sgName).putIfAbsent(vgId, new HashMap());
                this.allSGs.get(sgName).putIfAbsent(vgId, new HashSet());
                for (Map.Entry innerEntry : ((Map)entry.getValue()).entrySet()) {
                    timeRangeId = (Long)innerEntry.getKey();
                    this.toBeSyncedFilesMap.get(sgName).get(vgId).putIfAbsent(timeRangeId, new HashSet());
                    this.allSGs.get(sgName).get(vgId).add(timeRangeId);
                    for (File newFile : (Set)innerEntry.getValue()) {
                        if (this.lastLocalFilesMap.getOrDefault(sgName, Collections.emptyMap()).getOrDefault(vgId, Collections.emptyMap()).getOrDefault(timeRangeId, Collections.emptySet()).contains(newFile)) continue;
                        this.toBeSyncedFilesMap.get(sgName).get(vgId).get(timeRangeId).add(newFile);
                    }
                }
            }
            for (Map.Entry entry : this.lastLocalFilesMap.getOrDefault(sgName, Collections.emptyMap()).entrySet()) {
                vgId = (Long)entry.getKey();
                this.deletedFilesMap.get(sgName).putIfAbsent(vgId, new HashMap());
                this.allSGs.get(sgName).putIfAbsent(vgId, new HashSet());
                for (Map.Entry innerEntry : ((Map)entry.getValue()).entrySet()) {
                    timeRangeId = (Long)innerEntry.getKey();
                    this.deletedFilesMap.get(sgName).get(vgId).putIfAbsent(timeRangeId, new HashSet());
                    this.allSGs.get(sgName).get(vgId).add(timeRangeId);
                    for (File oldFile : (Set)innerEntry.getValue()) {
                        if (this.currentSealedLocalFilesMap.getOrDefault(sgName, Collections.emptyMap()).getOrDefault(vgId, Collections.emptyMap()).getOrDefault(timeRangeId, Collections.emptySet()).contains(oldFile)) continue;
                        this.deletedFilesMap.get(sgName).get(vgId).get(timeRangeId).add(oldFile);
                    }
                }
            }
        }
    }

    @Override
    public Map<String, Map<Long, Map<Long, Set<File>>>> getCurrentSealedLocalFilesMap() {
        return this.currentSealedLocalFilesMap;
    }

    @Override
    public Map<String, Map<Long, Map<Long, Set<File>>>> getLastLocalFilesMap() {
        return this.lastLocalFilesMap;
    }

    @Override
    public Map<String, Map<Long, Map<Long, Set<File>>>> getDeletedFilesMap() {
        return this.deletedFilesMap;
    }

    @Override
    public Map<String, Map<Long, Map<Long, Set<File>>>> getToBeSyncedFilesMap() {
        return this.toBeSyncedFilesMap;
    }

    @Override
    public Map<String, Map<Long, Set<Long>>> getAllSGs() {
        return this.allSGs;
    }

    private static class SyncFileManagerHolder {
        private static final SyncFileManager INSTANCE = new SyncFileManager();

        private SyncFileManagerHolder() {
        }
    }
}

