/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.SyncDeviceOwnerConflictException;
import org.apache.iotdb.db.sync.receiver.load.IFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoaderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLoaderManager.class);
    private static final int WAIT_TIMEOUT = 2000;
    private ConcurrentHashMap<String, IFileLoader> fileLoaderMap;
    private ExecutorService loadTaskRunnerPool;
    private Map<String, String> deviceOwnerMap = new HashMap<String, String>();
    private File deviceOwnerFile;
    private File deviceOwnerTmpFile;

    private FileLoaderManager() {
        String syncSystemDir = IoTDBDescriptor.getInstance().getConfig().getSyncDir();
        this.deviceOwnerFile = new File(syncSystemDir, "device_owner");
        this.deviceOwnerTmpFile = new File(syncSystemDir, "device_owner.tmp");
        try {
            this.recoverDeviceOwnerMap();
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("Can not recover device owner map from file {}", (Object)new File(syncSystemDir, "device_owner").getAbsolutePath());
        }
    }

    public static FileLoaderManager getInstance() {
        return FileLoaderManagerHolder.INSTANCE;
    }

    private void recoverDeviceOwnerMap() throws IOException, ClassNotFoundException {
        if (this.deviceOwnerTmpFile.exists()) {
            this.deviceOwnerFile.delete();
            FileUtils.moveFile((File)this.deviceOwnerTmpFile, (File)this.deviceOwnerFile);
        }
        if (this.deviceOwnerFile.exists()) {
            this.deSerializeDeviceOwnerMap(this.deviceOwnerFile);
        }
    }

    public synchronized void checkAndUpdateDeviceOwner(TsFileResource tsFileResource) throws SyncDeviceOwnerConflictException, IOException {
        String curOwner = tsFileResource.getTsFile().getParentFile().getParentFile().getParentFile().getName();
        Set<String> deviceSet = tsFileResource.getDevices();
        this.checkDeviceConflict(curOwner, deviceSet);
        this.updateDeviceOwner(curOwner, deviceSet);
    }

    private void checkDeviceConflict(String curOwner, Set<String> deviceSet) throws SyncDeviceOwnerConflictException {
        for (String device : deviceSet) {
            if (!this.deviceOwnerMap.containsKey(device) || this.deviceOwnerMap.get(device).equals(curOwner)) continue;
            throw new SyncDeviceOwnerConflictException(device, this.deviceOwnerMap.get(device), curOwner);
        }
    }

    private void updateDeviceOwner(String curOwner, Set<String> deviceSet) throws IOException {
        boolean modify = false;
        for (String device : deviceSet) {
            if (this.deviceOwnerMap.containsKey(device)) continue;
            this.deviceOwnerMap.put(device, curOwner);
            modify = true;
        }
        if (modify) {
            this.serializeDeviceOwnerMap(this.deviceOwnerTmpFile);
            this.deviceOwnerFile.delete();
            FileUtils.moveFile((File)this.deviceOwnerTmpFile, (File)this.deviceOwnerFile);
        }
    }

    private void deSerializeDeviceOwnerMap(File deviceOwnerFile) throws IOException, ClassNotFoundException {
        try (FileInputStream fis = new FileInputStream(deviceOwnerFile);
             ObjectInputStream deviceOwnerInput = new ObjectInputStream(fis);){
            this.deviceOwnerMap = (Map)deviceOwnerInput.readObject();
        }
    }

    private void serializeDeviceOwnerMap(File deviceOwnerFile) throws IOException {
        if (!deviceOwnerFile.getParentFile().exists()) {
            deviceOwnerFile.getParentFile().mkdirs();
        }
        if (!deviceOwnerFile.exists()) {
            deviceOwnerFile.createNewFile();
        }
        try (FileOutputStream fos = new FileOutputStream(deviceOwnerFile, false);
             ObjectOutputStream deviceOwnerOutput = new ObjectOutputStream(fos);){
            deviceOwnerOutput.writeObject(this.deviceOwnerMap);
        }
    }

    public void addFileLoader(String senderName, IFileLoader fileLoader) {
        this.fileLoaderMap.put(senderName, fileLoader);
    }

    public void removeFileLoader(String senderName) {
        this.fileLoaderMap.remove(senderName);
    }

    public IFileLoader getFileLoader(String senderName) {
        return this.fileLoaderMap.get(senderName);
    }

    public boolean containsFileLoader(String senderName) {
        return this.fileLoaderMap.containsKey(senderName);
    }

    public void addLoadTaskRunner(Runnable taskRunner) {
        this.loadTaskRunnerPool.submit(taskRunner);
    }

    public void start() {
        if (this.fileLoaderMap == null) {
            this.fileLoaderMap = new ConcurrentHashMap();
        }
        if (this.loadTaskRunnerPool == null) {
            this.loadTaskRunnerPool = IoTDBThreadPoolFactory.newCachedThreadPool(ThreadName.LOAD_TSFILE.getName());
        }
    }

    public void stop() {
        this.fileLoaderMap = null;
        this.loadTaskRunnerPool.shutdownNow();
        int totalWaitTime = 2000;
        while (!this.loadTaskRunnerPool.isTerminated()) {
            try {
                if (!this.loadTaskRunnerPool.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                    LOGGER.info("File load manager thread pool doesn't exit after {}ms.", (Object)totalWaitTime);
                }
                totalWaitTime += 2000;
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted while waiting file load manager thread pool to exit. ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.loadTaskRunnerPool = null;
    }

    private static class FileLoaderManagerHolder {
        private static final FileLoaderManager INSTANCE = new FileLoaderManager();

        private FileLoaderManagerHolder() {
        }
    }
}

