/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LastValueAggrResult
extends AggregateResult {
    protected long timestamp = Long.MIN_VALUE;

    public LastValueAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.LAST_VALUE);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.timestamp = Long.MIN_VALUE;
    }

    @Override
    public Object getResult() {
        return this.hasCandidateResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        Serializable lastVal = statistics.getLastValue();
        this.setValue(lastVal);
        this.timestamp = statistics.getEndTime();
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator) {
        this.updateResultFromPageData(batchIterator, time -> false);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, Predicate<Long> boundPredicate) {
        long time = Long.MIN_VALUE;
        Object lastVal = null;
        while (batchIterator.hasNext(boundPredicate) && !boundPredicate.test(batchIterator.currentTime())) {
            time = batchIterator.currentTime();
            lastVal = batchIterator.currentValue();
            batchIterator.next();
        }
        if (time != Long.MIN_VALUE) {
            this.setValue(lastVal);
            this.timestamp = time;
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = length - 1; i >= 0; --i) {
            if (values[i] == null) continue;
            this.timestamp = timestamps[i];
            this.setValue(values[i]);
            return;
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        for (int i = length - 1; i >= 0; --i) {
            if (valueIterator.get(i) == null) continue;
            this.timestamp = timestamps[i];
            this.setValue(valueIterator.get(i));
            return;
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        LastValueAggrResult anotherLast = (LastValueAggrResult)another;
        if (this.getValue() == null || this.timestamp < anotherLast.timestamp) {
            this.setValue(anotherLast.getValue());
            this.timestamp = anotherLast.timestamp;
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
        this.timestamp = buffer.getLong();
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((long)this.timestamp, (OutputStream)outputStream);
    }
}

