/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.logfile;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.logfile.MLogTxtReader;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.metadata.tag.TagLogFile;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogUpgrader {
    private static final Logger logger = LoggerFactory.getLogger(MLogUpgrader.class);
    private static final String DELETE_FAILED_FORMAT = "Deleting %s failed with exception %s";
    private MLogWriter mLogWriter;
    private MLogTxtReader mLogTxtReader;
    private TagLogFile tagLogFile;
    private String schemaDir;
    private String oldFileName;
    private String newFileName;
    private boolean isSnapshot;

    public MLogUpgrader(String schemaDir, String oldFileName, String newFileName, boolean isSnapshot) {
        this.schemaDir = schemaDir;
        this.oldFileName = oldFileName;
        this.newFileName = newFileName;
        this.isSnapshot = isSnapshot;
    }

    public static synchronized void upgradeMLog() throws IOException {
        String schemaDir = IoTDBDescriptor.getInstance().getConfig().getSchemaDir();
        MLogUpgrader mLogUpgrader = new MLogUpgrader(schemaDir, "mlog.txt", "mlog.bin", false);
        mLogUpgrader.upgradeTxtToBin();
        MLogUpgrader mTreeSnapshotUpgrader = new MLogUpgrader(schemaDir, "mtree-1.snapshot", "mtree-1.snapshot.bin", true);
        mTreeSnapshotUpgrader.upgradeTxtToBin();
    }

    public void upgradeTxtToBin() throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(this.schemaDir + File.separator + this.newFileName);
        File tmpLogFile = SystemFileFactory.INSTANCE.getFile(logFile.getAbsolutePath() + ".tmp");
        File oldLogFile = SystemFileFactory.INSTANCE.getFile(this.schemaDir + File.separator + this.oldFileName);
        File tmpOldLogFile = SystemFileFactory.INSTANCE.getFile(oldLogFile.getAbsolutePath() + ".tmp");
        if (oldLogFile.exists() || tmpOldLogFile.exists()) {
            String cmd;
            if (tmpOldLogFile.exists() && !oldLogFile.exists()) {
                FileUtils.moveFile((File)tmpOldLogFile, (File)oldLogFile);
            }
            this.mLogWriter = new MLogWriter(this.schemaDir, this.newFileName + ".tmp");
            this.mLogTxtReader = new MLogTxtReader(this.schemaDir, this.oldFileName);
            this.tagLogFile = new TagLogFile(IoTDBDescriptor.getInstance().getConfig().getSchemaDir(), "tlog.txt");
            while (this.mLogTxtReader.hasNext() && (cmd = this.mLogTxtReader.next()) != null) {
                try {
                    this.operation(cmd, this.isSnapshot);
                }
                catch (MetadataException e) {
                    logger.error("failed to upgrade cmd {}.", (Object)cmd, (Object)e);
                }
            }
            this.mLogWriter.close();
            FSFactoryProducer.getFSFactory().moveFile(tmpLogFile, logFile);
        } else if (logFile.exists() || tmpLogFile.exists()) {
            if (!logFile.exists() && tmpLogFile.exists()) {
                FSFactoryProducer.getFSFactory().moveFile(tmpLogFile, logFile);
            } else if (tmpLogFile.exists()) {
                try {
                    Files.delete(Paths.get(tmpLogFile.toURI()));
                }
                catch (IOException e) {
                    throw new IOException(String.format(DELETE_FAILED_FORMAT, tmpLogFile, e.getMessage()));
                }
            }
        }
        if (oldLogFile.exists()) {
            try {
                if (this.mLogTxtReader != null) {
                    this.mLogTxtReader.close();
                }
                Files.delete(Paths.get(oldLogFile.toURI()));
            }
            catch (IOException e) {
                throw new IOException(String.format(DELETE_FAILED_FORMAT, oldLogFile, e.getMessage()));
            }
        }
        if (tmpOldLogFile.exists()) {
            try {
                Files.delete(Paths.get(tmpOldLogFile.toURI()));
            }
            catch (IOException e) {
                throw new IOException(String.format(DELETE_FAILED_FORMAT, tmpOldLogFile, e.getMessage()));
            }
        }
        if (this.mLogWriter != null) {
            this.mLogWriter.close();
        }
        if (this.mLogTxtReader != null) {
            this.mLogTxtReader.close();
        }
        if (this.tagLogFile != null) {
            this.tagLogFile.close();
        }
    }

    public synchronized void operation(String cmd, boolean isSnapshot) throws IOException, MetadataException {
        if (!isSnapshot) {
            this.operation(cmd);
        } else {
            PhysicalPlan plan = MLogWriter.convertFromString(cmd);
            if (plan != null) {
                this.mLogWriter.putLog(plan);
            }
        }
    }

    public synchronized void operation(String cmd) throws IOException, MetadataException {
        String[] args = cmd.trim().split(",", -1);
        switch (args[0]) {
            case "0": {
                if (args.length > 8) {
                    int i;
                    String[] tmpArgs = new String[8];
                    tmpArgs[0] = args[0];
                    tmpArgs[1] = "";
                    for (i = 1; i < args.length - 7; ++i) {
                        tmpArgs[1] = tmpArgs[1] + args[i] + ",";
                    }
                    tmpArgs[1] = tmpArgs[1] + args[i++];
                    for (int j = 2; j < 8; ++j) {
                        tmpArgs[j] = args[i++];
                    }
                    args = tmpArgs;
                }
                HashMap<String, String> props = null;
                if (!args[5].isEmpty()) {
                    String[] keyValues = args[5].split("&");
                    props = new HashMap<String, String>();
                    for (String keyValue : keyValues) {
                        String[] kv = keyValue.split("=");
                        props.put(kv[0], kv[1]);
                    }
                }
                String alias = null;
                if (!args[6].isEmpty()) {
                    alias = args[6];
                }
                long offset = -1L;
                Map tags = null;
                Map attributes = null;
                if (!args[7].isEmpty()) {
                    offset = Long.parseLong(args[7]);
                    Pair<Map<String, String>, Map<String, String>> tagAttributePair = this.tagLogFile.read(IoTDBDescriptor.getInstance().getConfig().getTagAttributeTotalSize(), offset);
                    tags = (Map)tagAttributePair.left;
                    attributes = (Map)tagAttributePair.right;
                }
                CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(new PartialPath(args[1]), TSDataType.deserialize((byte)((byte)Short.parseShort(args[2]))), TSEncoding.deserialize((byte)((byte)Short.parseShort(args[3]))), CompressionType.deserialize((byte)((byte)Short.parseShort(args[4]))), props, tags, attributes, alias);
                plan.setTagOffset(offset);
                this.mLogWriter.createTimeseries(plan);
                break;
            }
            case "3": 
            case "4": {
                logger.warn("Impossible operation!");
                break;
            }
            case "1": {
                if (args.length > 2) {
                    StringBuilder tmp = new StringBuilder();
                    for (int i = 1; i < args.length - 1; ++i) {
                        tmp.append(args[i]).append(",");
                    }
                    tmp.append(args[args.length - 1]);
                    args[1] = tmp.toString();
                }
                this.mLogWriter.deleteTimeseries(new DeleteTimeSeriesPlan(Collections.singletonList(new PartialPath(args[1]))));
                break;
            }
            case "2": {
                try {
                    this.mLogWriter.setStorageGroup(new PartialPath(args[1]));
                }
                catch (MetadataException e) {
                    logger.info("concurrently operate set storage group cmd {} twice", (Object)cmd);
                }
                break;
            }
            case "11": {
                this.mLogWriter.deleteStorageGroup(new PartialPath(args[1]));
                break;
            }
            case "10": {
                this.mLogWriter.setTTL(new PartialPath(args[1]), Long.parseLong(args[2]));
                break;
            }
            case "12": {
                this.mLogWriter.changeOffset(new PartialPath(args[1]), Long.parseLong(args[2]));
                break;
            }
            case "13": {
                this.mLogWriter.changeAlias(new PartialPath(args[1]), args[2]);
                break;
            }
            default: {
                logger.error("Unrecognizable command {}", (Object)cmd);
            }
        }
    }
}

