/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.lastCache.container;

import org.apache.iotdb.db.metadata.lastCache.container.ILastCacheContainer;
import org.apache.iotdb.db.metadata.lastCache.container.value.ILastCacheValue;
import org.apache.iotdb.db.metadata.lastCache.container.value.LastCacheValue;
import org.apache.iotdb.tsfile.read.TimeValuePair;

public class LastCacheContainer
implements ILastCacheContainer {
    ILastCacheValue lastCacheValue;

    @Override
    public TimeValuePair getCachedLast() {
        return this.lastCacheValue == null ? null : this.lastCacheValue.getTimeValuePair();
    }

    @Override
    public synchronized void updateCachedLast(TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        if (timeValuePair == null || timeValuePair.getValue() == null) {
            return;
        }
        if (this.lastCacheValue == null) {
            if (!highPriorityUpdate || latestFlushedTime <= timeValuePair.getTimestamp()) {
                this.lastCacheValue = new LastCacheValue(timeValuePair.getTimestamp(), timeValuePair.getValue());
            }
        } else if (timeValuePair.getTimestamp() > this.lastCacheValue.getTimestamp() || timeValuePair.getTimestamp() == this.lastCacheValue.getTimestamp() && highPriorityUpdate) {
            this.lastCacheValue.setTimestamp(timeValuePair.getTimestamp());
            this.lastCacheValue.setValue(timeValuePair.getValue());
        }
    }

    @Override
    public synchronized void resetLastCache() {
        this.lastCacheValue = null;
    }

    @Override
    public boolean isEmpty() {
        return this.lastCacheValue == null;
    }
}

