/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.upgrade;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.concurrent.WrappedRunnable;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.upgrade.UpgradeCheckStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.tools.upgrade.TsFileOnlineUpgradeTool;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask
extends WrappedRunnable {
    private TsFileResource upgradeResource;
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTask.class);
    private static final String COMMA_SEPERATOR = ",";
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();

    public UpgradeTask(TsFileResource upgradeResource) {
        this.upgradeResource = upgradeResource;
    }

    @Override
    public void runMayThrow() {
        try {
            List<TsFileResource> upgradedResources;
            String oldTsfilePath = this.upgradeResource.getTsFile().getAbsolutePath();
            if (!UpgradeUtils.isUpgradedFileGenerated(this.upgradeResource.getTsFile().getName())) {
                logger.info("generate upgraded file for {}", (Object)this.upgradeResource.getTsFile());
                upgradedResources = this.generateUpgradedFiles();
            } else {
                logger.info("find upgraded file for {}", (Object)this.upgradeResource.getTsFile());
                upgradedResources = this.findUpgradedFiles();
            }
            this.upgradeResource.setUpgradedResources(upgradedResources);
            this.upgradeResource.getUpgradeTsFileResourceCallBack().call(this.upgradeResource);
            UpgradeSevice.getTotalUpgradeFileNum().getAndAdd(-1);
            logger.info("Upgrade completes, file path:{} , the remaining upgraded file num: {}", (Object)oldTsfilePath, (Object)UpgradeSevice.getTotalUpgradeFileNum().get());
            if (UpgradeSevice.getTotalUpgradeFileNum().get() == 0) {
                logger.info("Start delete empty tmp folders");
                this.clearTmpFolders(DirectoryManager.getInstance().getAllSequenceFileFolders());
                this.clearTmpFolders(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
                UpgradeSevice.getINSTANCE().stop();
                logger.info("All files upgraded successfully! ");
            }
        }
        catch (Exception e) {
            logger.error("meet error when upgrade file:{}", (Object)this.upgradeResource.getTsFile().getAbsolutePath(), (Object)e);
        }
    }

    private List<TsFileResource> generateUpgradedFiles() throws IOException, WriteProcessException {
        this.upgradeResource.readLock();
        String oldTsfilePath = this.upgradeResource.getTsFile().getAbsolutePath();
        ArrayList<TsFileResource> upgradedResources = new ArrayList<TsFileResource>();
        UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.BEGIN_UPGRADE_FILE));
        try {
            TsFileOnlineUpgradeTool.upgradeOneTsFile(this.upgradeResource, upgradedResources);
            UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.AFTER_UPGRADE_FILE));
        }
        finally {
            this.upgradeResource.readUnlock();
        }
        return upgradedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TsFileResource> findUpgradedFiles() throws IOException {
        this.upgradeResource.readLock();
        ArrayList<TsFileResource> upgradedResources = new ArrayList<TsFileResource>();
        String oldTsfilePath = this.upgradeResource.getTsFile().getAbsolutePath();
        UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.BEGIN_UPGRADE_FILE));
        try {
            File upgradeFolder = this.upgradeResource.getTsFile().getParentFile();
            for (File tempPartitionDir : upgradeFolder.listFiles()) {
                if (!tempPartitionDir.isDirectory() || !this.fsFactory.getFile(tempPartitionDir, this.upgradeResource.getTsFile().getName() + ".resource").exists()) continue;
                TsFileResource resource = new TsFileResource(this.fsFactory.getFile(tempPartitionDir, this.upgradeResource.getTsFile().getName()));
                resource.deserialize();
                upgradedResources.add(resource);
            }
            UpgradeLog.writeUpgradeLogFile(oldTsfilePath + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.AFTER_UPGRADE_FILE));
        }
        finally {
            this.upgradeResource.readUnlock();
        }
        return upgradedResources;
    }

    private void clearTmpFolders(List<String> folders) {
        for (String baseDir : folders) {
            File fileFolder = this.fsFactory.getFile(baseDir);
            if (!fileFolder.isDirectory()) continue;
            for (File storageGroup : fileFolder.listFiles()) {
                File[] tmpPartitionDirList;
                File virtualStorageGroupDir;
                File upgradeDir;
                if (!storageGroup.isDirectory() || (upgradeDir = this.fsFactory.getFile(virtualStorageGroupDir = this.fsFactory.getFile(storageGroup, "0"), "upgrade")) == null || (tmpPartitionDirList = upgradeDir.listFiles()) == null) continue;
                for (File tmpPartitionDir : tmpPartitionDirList) {
                    if (!tmpPartitionDir.isDirectory()) continue;
                    try {
                        Files.delete(tmpPartitionDir.toPath());
                    }
                    catch (IOException e) {
                        logger.error("Delete tmpPartitionDir {} failed", (Object)tmpPartitionDir);
                    }
                }
                if (!upgradeDir.isDirectory()) continue;
                try {
                    Files.delete(upgradeDir.toPath());
                }
                catch (IOException e) {
                    logger.error("Delete tmpUpgradeDir {} failed", (Object)upgradeDir);
                }
            }
        }
    }
}

