/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.service;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.writelog.io.ILogWriter;
import org.apache.iotdb.db.writelog.io.LogWriter;

public class TriggerLogWriter
implements AutoCloseable {
    private final ByteBuffer logBuffer = ByteBuffer.allocate(IoTDBDescriptor.getInstance().getConfig().getTlogBufferSize());
    private final File logFile;
    private final ILogWriter logWriter;

    public TriggerLogWriter(String logFilePath) throws IOException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFilePath);
        this.logWriter = new LogWriter(this.logFile, false);
    }

    public synchronized void write(PhysicalPlan plan) throws IOException {
        try {
            plan.serialize(this.logBuffer);
            this.logWriter.write(this.logBuffer);
        }
        catch (BufferOverflowException e) {
            throw new IOException("Current trigger management operation plan is too large to write into buffer, please increase tlog_buffer_size.", e);
        }
        finally {
            this.logBuffer.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.logWriter.close();
    }

    public void deleteLogFile() throws IOException {
        FileUtils.forceDelete((File)this.logFile);
    }
}

