/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite.manage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;

public class CrossSpaceCompactionResource {
    private List<TsFileResource> seqFiles;
    private List<TsFileResource> unseqFiles = new ArrayList<TsFileResource>();
    private Map<TsFileResource, TsFileSequenceReader> fileReaderCache = new HashMap<TsFileResource, TsFileSequenceReader>();
    private Map<TsFileResource, RestorableTsFileIOWriter> fileWriterCache = new HashMap<TsFileResource, RestorableTsFileIOWriter>();
    private Map<TsFileResource, List<Modification>> modificationCache = new HashMap<TsFileResource, List<Modification>>();
    private Map<TsFileResource, Map<String, Pair<Long, Long>>> startEndTimeCache = new HashMap<TsFileResource, Map<String, Pair<Long, Long>>>();
    private Map<IMeasurementSchema, ChunkWriterImpl> chunkWriterCache = new ConcurrentHashMap<IMeasurementSchema, ChunkWriterImpl>();
    private long ttlLowerBound = Long.MIN_VALUE;
    private boolean cacheDeviceMeta = false;

    public CrossSpaceCompactionResource(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = seqFiles.stream().filter(this::filterSeqResource).collect(Collectors.toList());
        this.filterUnseqResource(unseqFiles);
    }

    private boolean filterSeqResource(TsFileResource res) {
        return !res.isDeleted() && res.stillLives(this.ttlLowerBound);
    }

    private void filterUnseqResource(List<TsFileResource> unseqResources) {
        for (TsFileResource resource : unseqResources) {
            if (resource.getStatus() != TsFileResourceStatus.CLOSED || !resource.getTsFile().exists()) {
                return;
            }
            if (!resource.stillLives(this.ttlLowerBound)) continue;
            this.unseqFiles.add(resource);
        }
    }

    public CrossSpaceCompactionResource(Collection<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, long ttlLowerBound) {
        this.ttlLowerBound = ttlLowerBound;
        this.seqFiles = seqFiles.stream().filter(this::filterSeqResource).collect(Collectors.toList());
        this.filterUnseqResource(unseqFiles);
    }

    public void clear() throws IOException {
        for (TsFileSequenceReader sequenceReader : this.fileReaderCache.values()) {
            sequenceReader.close();
        }
        for (RestorableTsFileIOWriter writer : this.fileWriterCache.values()) {
            writer.close();
        }
        this.fileReaderCache.clear();
        this.fileWriterCache.clear();
        this.modificationCache.clear();
        this.chunkWriterCache.clear();
    }

    public TsFileSequenceReader getFileReader(TsFileResource tsFileResource) throws IOException {
        TsFileSequenceReader reader = this.fileReaderCache.get(tsFileResource);
        if (reader == null) {
            reader = new TsFileSequenceReader(tsFileResource.getTsFilePath(), true, this.cacheDeviceMeta);
            this.fileReaderCache.put(tsFileResource, reader);
        }
        return reader;
    }

    public List<Modification> getModifications(TsFileResource tsFileResource, PartialPath path) {
        List modifications = this.modificationCache.computeIfAbsent(tsFileResource, resource -> new LinkedList<Modification>(resource.getModFile().getModifications()));
        ArrayList<Modification> pathModifications = new ArrayList<Modification>();
        for (Modification modification : modifications) {
            if (!modification.getPath().matchFullPath(path)) continue;
            pathModifications.add(modification);
        }
        return pathModifications;
    }

    public List<TsFileResource> getSeqFiles() {
        return this.seqFiles;
    }

    public void setSeqFiles(List<TsFileResource> seqFiles) {
        this.seqFiles = seqFiles;
    }

    public List<TsFileResource> getUnseqFiles() {
        return this.unseqFiles;
    }

    public void setUnseqFiles(List<TsFileResource> unseqFiles) {
        this.unseqFiles = unseqFiles;
    }

    public void removeOutdatedSeqReaders() throws IOException {
        Iterator<Map.Entry<TsFileResource, TsFileSequenceReader>> entryIterator = this.fileReaderCache.entrySet().iterator();
        HashSet<TsFileResource> fileSet = new HashSet<TsFileResource>(this.seqFiles);
        while (entryIterator.hasNext()) {
            Map.Entry<TsFileResource, TsFileSequenceReader> entry = entryIterator.next();
            TsFileResource tsFile = entry.getKey();
            if (fileSet.contains(tsFile)) continue;
            TsFileSequenceReader reader = entry.getValue();
            reader.close();
            entryIterator.remove();
        }
    }

    public void setCacheDeviceMeta(boolean cacheDeviceMeta) {
        this.cacheDeviceMeta = cacheDeviceMeta;
    }

    public void updateStartTime(TsFileResource tsFileResource, String device, long startTime) {
        Map deviceStartEndTimePairMap = this.startEndTimeCache.getOrDefault(tsFileResource, new HashMap());
        Pair startEndTimePair = deviceStartEndTimePairMap.getOrDefault(device, new Pair((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE));
        long newStartTime = (Long)startEndTimePair.left > startTime ? startTime : (Long)startEndTimePair.left;
        deviceStartEndTimePairMap.put(device, new Pair((Object)newStartTime, (Object)((Long)startEndTimePair.right)));
        this.startEndTimeCache.put(tsFileResource, deviceStartEndTimePairMap);
    }

    public void updateEndTime(TsFileResource tsFileResource, String device, long endTime) {
        Map deviceStartEndTimePairMap = this.startEndTimeCache.getOrDefault(tsFileResource, new HashMap());
        Pair startEndTimePair = deviceStartEndTimePairMap.getOrDefault(device, new Pair((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE));
        long newEndTime = (Long)startEndTimePair.right < endTime ? endTime : (Long)startEndTimePair.right;
        deviceStartEndTimePairMap.put(device, new Pair((Object)((Long)startEndTimePair.left), (Object)newEndTime));
        this.startEndTimeCache.put(tsFileResource, deviceStartEndTimePairMap);
    }

    public Map<String, Pair<Long, Long>> getStartEndTime(TsFileResource tsFileResource) {
        return this.startEndTimeCache.getOrDefault(tsFileResource, new HashMap());
    }
}

