/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.TimeIndexLevel;

public class TsFileDeviceInfoStore {
    private Map<TsFileResource, TsFileDeviceInfo> cache = new HashMap<TsFileResource, TsFileDeviceInfo>();

    public TsFileDeviceInfo get(TsFileResource tsFileResource) {
        return this.cache.computeIfAbsent(tsFileResource, TsFileDeviceInfo::new);
    }

    public static class DeviceInfo {
        public String deviceId;
        public long startTime;
        public long endTime;

        public DeviceInfo(String deviceId, long startTime, long endTime) {
            this.deviceId = deviceId;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }

    public static class TsFileDeviceInfo {
        public TsFileResource resource;
        private Map<String, DeviceInfo> deviceInfoMap;

        public TsFileDeviceInfo(TsFileResource tsFileResource) {
            this.resource = tsFileResource;
        }

        private void prepareDeviceInfos() throws IOException {
            if (this.deviceInfoMap != null) {
                return;
            }
            this.deviceInfoMap = new LinkedHashMap<String, DeviceInfo>();
            if (TimeIndexLevel.valueOf(this.resource.getTimeIndexType()) == TimeIndexLevel.FILE_TIME_INDEX) {
                DeviceTimeIndex timeIndex = this.resource.buildDeviceTimeIndex();
                for (String deviceId : timeIndex.getDevices()) {
                    this.deviceInfoMap.put(deviceId, new DeviceInfo(deviceId, timeIndex.getStartTime(deviceId), timeIndex.getEndTime(deviceId)));
                }
            } else {
                for (String deviceId : this.resource.getDevices()) {
                    this.deviceInfoMap.put(deviceId, new DeviceInfo(deviceId, this.resource.getStartTime(deviceId), this.resource.getEndTime(deviceId)));
                }
            }
        }

        public List<DeviceInfo> getDevices() throws IOException {
            this.prepareDeviceInfos();
            return new ArrayList<DeviceInfo>(this.deviceInfoMap.values());
        }

        public DeviceInfo getDeviceInfoById(String deviceId) throws IOException {
            this.prepareDeviceInfos();
            return this.deviceInfoMap.get(deviceId);
        }

        public boolean containsDevice(String deviceId) throws IOException {
            this.prepareDeviceInfos();
            return this.deviceInfoMap.containsKey(deviceId);
        }
    }
}

