/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;

public class InternalMNode
extends MNode {
    private static final long serialVersionUID = -770028375899514063L;
    protected volatile transient Map<String, IMNode> children = null;
    protected Template schemaTemplate = null;
    private volatile boolean useTemplate = false;

    public InternalMNode(IMNode parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey(name);
    }

    @Override
    public IMNode getChild(String name) {
        IMNode child = null;
        if (this.children != null) {
            child = this.children.get(name);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(String name, IMNode child) {
        if (this.children == null) {
            InternalMNode internalMNode = this;
            synchronized (internalMNode) {
                if (this.children == null) {
                    this.children = new ConcurrentHashMap<String, IMNode>();
                }
            }
        }
        child.setParent(this);
        this.children.putIfAbsent(name, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode addChild(IMNode child) {
        if (this.children == null) {
            InternalMNode internalMNode = this;
            synchronized (internalMNode) {
                if (this.children == null) {
                    this.children = new ConcurrentHashMap<String, IMNode>();
                }
            }
        }
        child.setParent(this);
        this.children.putIfAbsent(child.getName(), child);
        return child;
    }

    @Override
    public void deleteChild(String name) {
        if (this.children != null) {
            this.children.remove(name);
        }
    }

    @Override
    public synchronized void replaceChild(String oldChildName, IMNode newChildNode) {
        if (!oldChildName.equals(newChildNode.getName())) {
            throw new RuntimeException("New child's name must be the same as old child's name!");
        }
        IMNode oldChildNode = this.getChild(oldChildName);
        if (oldChildNode == null) {
            return;
        }
        Map<String, IMNode> grandChildren = oldChildNode.getChildren();
        if (!grandChildren.isEmpty()) {
            newChildNode.setChildren(grandChildren);
            grandChildren.forEach((grandChildName, grandChildNode) -> grandChildNode.setParent(newChildNode));
        }
        if (newChildNode.isEntity() && oldChildNode.isEntity()) {
            Map<String, IMeasurementMNode> grandAliasChildren = oldChildNode.getAsEntityMNode().getAliasChildren();
            if (!grandAliasChildren.isEmpty()) {
                newChildNode.getAsEntityMNode().setAliasChildren(grandAliasChildren);
                grandAliasChildren.forEach((grandAliasChildName, grandAliasChild) -> grandAliasChild.setParent(newChildNode));
            }
            newChildNode.getAsEntityMNode().setUseTemplate(oldChildNode.isUseTemplate());
        }
        newChildNode.setSchemaTemplate(oldChildNode.getSchemaTemplate());
        newChildNode.setParent(this);
        this.children.replace(oldChildName, newChildNode);
    }

    @Override
    public Map<String, IMNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyMap();
        }
        return this.children;
    }

    @Override
    public void setChildren(Map<String, IMNode> children) {
        this.children = children;
    }

    @Override
    public Template getUpperTemplate() {
        for (IMNode cur = this; cur != null; cur = cur.getParent()) {
            if (cur.getSchemaTemplate() == null) continue;
            return cur.getSchemaTemplate();
        }
        return null;
    }

    @Override
    public Template getSchemaTemplate() {
        return this.schemaTemplate;
    }

    @Override
    public void setSchemaTemplate(Template schemaTemplate) {
        this.schemaTemplate = schemaTemplate;
    }

    @Override
    public boolean isUseTemplate() {
        return this.useTemplate;
    }

    @Override
    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    @Override
    public void serializeTo(MLogWriter logWriter) throws IOException {
        this.serializeChildren(logWriter);
        logWriter.serializeMNode(this);
    }

    void serializeChildren(MLogWriter logWriter) throws IOException {
        if (this.children == null) {
            return;
        }
        for (Map.Entry<String, IMNode> entry : this.children.entrySet()) {
            entry.getValue().serializeTo(logWriter);
        }
    }

    public static InternalMNode deserializeFrom(MNodePlan plan) {
        return new InternalMNode(null, plan.getName());
    }
}

