/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.catchup;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntriesRequest;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.handlers.caller.LogCatchUpHandler;
import org.apache.iotdb.cluster.server.handlers.caller.LogCatchUpInBatchHandler;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCatchUpTask
implements Callable<Boolean> {
    private static final long SEND_LOGS_WAIT_MS = ClusterConstant.getWriteOperationTimeoutMS();
    private static final Logger logger = LoggerFactory.getLogger(LogCatchUpTask.class);
    Node node;
    RaftMember raftMember;
    private List<Log> logs;
    private boolean useBatch = ClusterDescriptor.getInstance().getConfig().isUseBatchInLogCatchUp();
    boolean abort = false;
    private int raftId;

    LogCatchUpTask(List<Log> logs, Node node, int raftId, RaftMember raftMember) {
        this.logs = logs;
        this.node = node;
        this.raftId = raftId;
        this.raftMember = raftMember;
    }

    LogCatchUpTask(List<Log> logs, Node node, int raftId, RaftMember raftMember, boolean useBatch) {
        this.logs = logs;
        this.node = node;
        this.raftId = raftId;
        this.raftMember = raftMember;
        this.useBatch = useBatch;
    }

    void setUseBatch(boolean useBatch) {
        this.useBatch = useBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLogCatchUp() throws TException, InterruptedException, LeaderUnknownException {
        AppendEntryRequest request = new AppendEntryRequest();
        if (this.raftMember.getHeader() != null) {
            request.setHeader(this.raftMember.getHeader());
        }
        request.setLeader(this.raftMember.getThisNode());
        request.setLeaderCommit(this.raftMember.getLogManager().getCommitLogIndex());
        for (int i = 0; i < this.logs.size() && !this.abort; ++i) {
            Log log = this.logs.get(i);
            AtomicLong atomicLong = this.raftMember.getTerm();
            synchronized (atomicLong) {
                if (this.raftMember.getCharacter() != NodeCharacter.LEADER) {
                    throw new LeaderUnknownException(this.raftMember.getAllNodes());
                }
                request.setTerm(this.raftMember.getTerm().get());
            }
            request.setPrevLogIndex(log.getCurrLogIndex() - 1L);
            if (i == 0) {
                try {
                    request.setPrevLogTerm(this.raftMember.getLogManager().getTerm(log.getCurrLogIndex() - 1L));
                }
                catch (Exception e) {
                    logger.error("getTerm failed for newly append entries", (Throwable)e);
                }
            } else {
                request.setPrevLogTerm(this.logs.get(i - 1).getCurrLogTerm());
            }
            this.abort = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? !this.appendEntryAsync(log, request) : !this.appendEntrySync(log, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean appendEntryAsync(Log log, AppendEntryRequest request) throws TException, InterruptedException {
        LogCatchUpHandler handler = this.getCatchUpHandler(log, request);
        AtomicBoolean atomicBoolean = handler.getAppendSucceed();
        synchronized (atomicBoolean) {
            RaftService.AsyncClient client = this.raftMember.getAsyncClient(this.node);
            if (client == null) {
                return false;
            }
            client.appendEntry(request, (AsyncMethodCallback)handler);
            this.raftMember.getLastCatchUpResponseTime().put(this.node, System.currentTimeMillis());
            handler.getAppendSucceed().wait(ClusterConstant.getWriteOperationTimeoutMS());
        }
        return handler.getAppendSucceed().get();
    }

    private LogCatchUpHandler getCatchUpHandler(Log log, AppendEntryRequest request) {
        AtomicBoolean appendSucceed = new AtomicBoolean(false);
        LogCatchUpHandler handler = new LogCatchUpHandler();
        handler.setAppendSucceed(appendSucceed);
        handler.setRaftMember(this.raftMember);
        handler.setFollower(this.node);
        handler.setLog(log);
        request.setEntry(log.serialize());
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean appendEntrySync(Log log, AppendEntryRequest request) {
        LogCatchUpHandler handler = this.getCatchUpHandler(log, request);
        RaftService.Client client = this.raftMember.getSyncClient(this.node);
        if (client == null) {
            logger.error("No available client for {} when append entry", (Object)this.node);
            return false;
        }
        try {
            long result = client.appendEntry(request);
            handler.onComplete(result);
            boolean bl = handler.getAppendSucceed().get();
            return bl;
        }
        catch (TException e) {
            client.getInputProtocol().getTransport().close();
            handler.onError((Exception)((Object)e));
            boolean bl = false;
            return bl;
        }
        finally {
            ClientUtils.putBackSyncClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppendEntriesRequest prepareRequest(List<ByteBuffer> logList, int startPos) {
        AppendEntriesRequest request = new AppendEntriesRequest();
        if (this.raftMember.getHeader() != null) {
            request.setHeader(this.raftMember.getHeader());
        }
        request.setLeader(this.raftMember.getThisNode());
        request.setLeaderCommit(this.raftMember.getLogManager().getCommitLogIndex());
        AtomicLong atomicLong = this.raftMember.getTerm();
        synchronized (atomicLong) {
            if (this.raftMember.getCharacter() != NodeCharacter.LEADER) {
                logger.debug("Leadership is lost when doing a catch-up to {}, aborting", (Object)this.node);
                this.abort = true;
                return null;
            }
            request.setTerm(this.raftMember.getTerm().get());
        }
        request.setEntries(logList);
        request.setPrevLogIndex(this.logs.get(startPos).getCurrLogIndex() - 1L);
        if (startPos != 0) {
            request.setPrevLogTerm(this.logs.get(startPos - 1).getCurrLogTerm());
        } else {
            try {
                request.setPrevLogTerm(this.raftMember.getLogManager().getTerm(this.logs.get(0).getCurrLogIndex() - 1L));
            }
            catch (Exception e) {
                logger.error("getTerm failed for newly append entries", (Throwable)e);
            }
        }
        logger.debug("{}, node={} catchup request={}", new Object[]{this.raftMember.getName(), this.node, request});
        return request;
    }

    private void doLogCatchUpInBatch() throws TException, InterruptedException {
        ArrayList<ByteBuffer> logList = new ArrayList<ByteBuffer>();
        long totalLogSize = 0L;
        int firstLogPos = 0;
        for (int i = 0; i < this.logs.size() && !this.abort; ++i) {
            boolean batchFull;
            ByteBuffer logData = this.logs.get(i).serialize();
            int logSize = logData.array().length;
            if (logSize > IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize() - 0x400000) {
                logger.warn("the frame size {} of thrift is too small", (Object)IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize());
                this.abort = true;
                return;
            }
            if ((totalLogSize += (long)logSize) > (long)(IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize() - 0x400000)) {
                this.sendBatchLogs(logList, firstLogPos);
                logList.add(logData);
                firstLogPos = i;
                totalLogSize = logSize;
            } else {
                logList.add(logData);
            }
            boolean bl = batchFull = logList.size() >= 100;
            if (!batchFull) continue;
            this.sendBatchLogs(logList, firstLogPos);
            firstLogPos = i + 1;
            totalLogSize = 0L;
        }
        if (!logList.isEmpty()) {
            this.sendBatchLogs(logList, firstLogPos);
        }
    }

    private void sendBatchLogs(List<ByteBuffer> logList, int firstLogPos) throws TException, InterruptedException {
        AppendEntriesRequest request;
        if (logger.isInfoEnabled()) {
            logger.info("{} send logs from {} num {} for {}", new Object[]{this.raftMember.getThisNode(), this.logs.get(firstLogPos).getCurrLogIndex(), logList.size(), this.node});
        }
        if ((request = this.prepareRequest(logList, firstLogPos)) == null) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("{}: sending {} logs to {}", new Object[]{this.raftMember.getName(), logList.size(), this.node});
        }
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            this.abort = !this.appendEntriesAsync(logList, request);
        } else {
            boolean bl = this.abort = !this.appendEntriesSync(logList, request);
        }
        if (!this.abort && logger.isInfoEnabled()) {
            logger.info("{}: sent {} logs to {}", new Object[]{this.raftMember.getName(), logList.size(), this.node});
        }
        logList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean appendEntriesAsync(List<ByteBuffer> logList, AppendEntriesRequest request) throws TException, InterruptedException {
        AtomicBoolean appendSucceed = new AtomicBoolean(false);
        LogCatchUpInBatchHandler handler = new LogCatchUpInBatchHandler();
        handler.setAppendSucceed(appendSucceed);
        handler.setRaftMember(this.raftMember);
        handler.setFollower(this.node);
        handler.setLogs(logList);
        AtomicBoolean atomicBoolean = appendSucceed;
        synchronized (atomicBoolean) {
            appendSucceed.set(false);
            RaftService.AsyncClient client = this.raftMember.getAsyncClient(this.node);
            if (client == null) {
                return false;
            }
            client.appendEntries(request, (AsyncMethodCallback)handler);
            this.raftMember.getLastCatchUpResponseTime().put(this.node, System.currentTimeMillis());
            appendSucceed.wait(SEND_LOGS_WAIT_MS);
        }
        return appendSucceed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean appendEntriesSync(List<ByteBuffer> logList, AppendEntriesRequest request) {
        AtomicBoolean appendSucceed = new AtomicBoolean(false);
        LogCatchUpInBatchHandler handler = new LogCatchUpInBatchHandler();
        handler.setAppendSucceed(appendSucceed);
        handler.setRaftMember(this.raftMember);
        handler.setFollower(this.node);
        handler.setLogs(logList);
        RaftService.Client client = this.raftMember.getSyncClient(this.node);
        if (client == null) {
            logger.error("No available client for {} when append entries", (Object)this.node);
            return false;
        }
        try {
            long result = client.appendEntries(request);
            handler.onComplete(result);
            boolean bl = appendSucceed.get();
            return bl;
        }
        catch (TException e) {
            client.getInputProtocol().getTransport().close();
            handler.onError((Exception)((Object)e));
            logger.warn("Failed logs: {}, first index: {}", logList, (Object)(request.prevLogIndex + 1L));
            boolean bl = false;
            return bl;
        }
        finally {
            ClientUtils.putBackSyncClient(client);
        }
    }

    @Override
    public Boolean call() throws TException, InterruptedException, LeaderUnknownException {
        if (this.logs.isEmpty()) {
            return true;
        }
        if (this.useBatch) {
            this.doLogCatchUpInBatch();
        } else {
            this.doLogCatchUp();
        }
        logger.info("{}: Catch up {} finished with result {}", new Object[]{this.raftMember.getName(), this.node, !this.abort});
        this.raftMember.getLastCatchUpResponseTime().remove(this.node);
        return !this.abort;
    }
}

