/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.cluster.config.ConsistencyLevel;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfig {
    private static Logger logger = LoggerFactory.getLogger(ClusterConfig.class);
    static final String CONFIG_NAME = "iotdb-cluster.properties";
    private String internalIp;
    private int internalMetaPort = 9003;
    private int internalDataPort = 40010;
    private int clusterRpcPort = IoTDBDescriptor.getInstance().getConfig().getRpcPort();
    private int clusterInfoRpcPort = 6567;
    private List<String> seedNodeUrls;
    private boolean isRpcThriftCompressionEnabled = false;
    private int replicationNum = 1;
    private int multiRaftFactor = 1;
    private String clusterName = "default";
    private boolean useAsyncServer = false;
    private boolean useAsyncApplier = true;
    private int connectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(20L);
    private long heartbeatIntervalMs = TimeUnit.SECONDS.toMillis(1L);
    private long electionTimeoutMs = TimeUnit.SECONDS.toMillis(20L);
    private int readOperationTimeoutMS = (int)TimeUnit.SECONDS.toMillis(30L);
    private int writeOperationTimeoutMS = (int)TimeUnit.SECONDS.toMillis(30L);
    private int catchUpTimeoutMS = (int)TimeUnit.SECONDS.toMillis(300L);
    private boolean useBatchInLogCatchUp = true;
    private int minNumOfLogsInMem = 1000;
    private int maxNumOfLogsInMem = 2000;
    private long maxMemorySizeForRaftLog = 0x20000000L;
    private double RaftLogMemoryProportion = 0.2;
    private int logDeleteCheckIntervalSecond = -1;
    private int maxClientPerNodePerMember = 1000;
    private int maxIdleClientPerNodePerMember = 500;
    private long waitClientTimeoutMS = 5000L;
    private int selectorNumOfClientPool = Runtime.getRuntime().availableProcessors() / 3 > 0 ? Runtime.getRuntime().availableProcessors() / 3 : 1;
    private boolean enableAutoCreateSchema = true;
    private boolean enableRaftLogPersistence = true;
    private int flushRaftLogThreshold = 10000;
    private int raftLogBufferSize = 0x1000000;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.MID_CONSISTENCY;
    private long joinClusterTimeOutMs = TimeUnit.SECONDS.toMillis(5L);
    private int pullSnapshotRetryIntervalMs = (int)TimeUnit.SECONDS.toMillis(5L);
    private int maxRaftLogIndexSizeInMemory = 10000;
    private int UnCommittedRaftLogNumForRejectThreshold = 500;
    private int UnAppliedRaftLogNumForRejectThreshold = 500;
    private int maxRaftLogPersistDataSizePerFile = 0x40000000;
    private int maxNumberOfPersistRaftLogFiles = 5;
    private int maxPersistRaftLogNumberOnDisk = 1000000;
    private boolean enableUsePersistLogOnDiskToCatchUp = true;
    private int maxNumberOfLogsPerFetchOnDisk = 1000;
    private boolean waitForSlowNode = true;
    private long maxReadLogLag = 1000L;
    private long maxSyncLogLag = 100000L;
    private boolean openServerRpcPort = false;

    public ClusterConfig() {
        try {
            this.internalIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage());
            this.internalIp = "127.0.0.1";
        }
        this.seedNodeUrls = Arrays.asList(String.format("%s:%d", this.internalIp, this.internalMetaPort));
    }

    public int getSelectorNumOfClientPool() {
        return this.selectorNumOfClientPool;
    }

    public int getMaxClientPerNodePerMember() {
        return this.maxClientPerNodePerMember;
    }

    public void setMaxClientPerNodePerMember(int maxClientPerNodePerMember) {
        this.maxClientPerNodePerMember = maxClientPerNodePerMember;
    }

    public int getMaxIdleClientPerNodePerMember() {
        return this.maxIdleClientPerNodePerMember;
    }

    public void setMaxIdleClientPerNodePerMember(int maxIdleClientPerNodePerMember) {
        this.maxIdleClientPerNodePerMember = maxIdleClientPerNodePerMember;
    }

    public boolean isUseBatchInLogCatchUp() {
        return this.useBatchInLogCatchUp;
    }

    public void setUseBatchInLogCatchUp(boolean useBatchInLogCatchUp) {
        this.useBatchInLogCatchUp = useBatchInLogCatchUp;
    }

    public int getInternalMetaPort() {
        return this.internalMetaPort;
    }

    public void setInternalMetaPort(int internalMetaPort) {
        this.internalMetaPort = internalMetaPort;
    }

    public boolean isRpcThriftCompressionEnabled() {
        return this.isRpcThriftCompressionEnabled;
    }

    void setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
        this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
    }

    public List<String> getSeedNodeUrls() {
        return this.seedNodeUrls;
    }

    public void setSeedNodeUrls(List<String> seedNodeUrls) {
        this.seedNodeUrls = seedNodeUrls;
    }

    public int getReplicationNum() {
        return this.replicationNum;
    }

    public void setReplicationNum(int replicationNum) {
        this.replicationNum = replicationNum;
    }

    public int getMultiRaftFactor() {
        return this.multiRaftFactor;
    }

    public void setMultiRaftFactor(int multiRaftFactor) {
        this.multiRaftFactor = multiRaftFactor;
    }

    void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getInternalDataPort() {
        return this.internalDataPort;
    }

    public void setInternalDataPort(int internalDataPort) {
        this.internalDataPort = internalDataPort;
    }

    public int getClusterRpcPort() {
        return this.clusterRpcPort;
    }

    public void setClusterRpcPort(int clusterRpcPort) {
        this.clusterRpcPort = clusterRpcPort;
    }

    public int getConnectionTimeoutInMS() {
        return this.connectionTimeoutInMS;
    }

    void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public int getCatchUpTimeoutMS() {
        return this.catchUpTimeoutMS;
    }

    public void setCatchUpTimeoutMS(int catchUpTimeoutMS) {
        this.catchUpTimeoutMS = catchUpTimeoutMS;
    }

    public int getReadOperationTimeoutMS() {
        return this.readOperationTimeoutMS;
    }

    void setReadOperationTimeoutMS(int readOperationTimeoutMS) {
        this.readOperationTimeoutMS = readOperationTimeoutMS;
    }

    public int getWriteOperationTimeoutMS() {
        return this.writeOperationTimeoutMS;
    }

    public void setWriteOperationTimeoutMS(int writeOperationTimeoutMS) {
        this.writeOperationTimeoutMS = writeOperationTimeoutMS;
    }

    public int getMinNumOfLogsInMem() {
        return this.minNumOfLogsInMem;
    }

    public void setMinNumOfLogsInMem(int minNumOfLogsInMem) {
        this.minNumOfLogsInMem = minNumOfLogsInMem;
    }

    public int getLogDeleteCheckIntervalSecond() {
        return this.logDeleteCheckIntervalSecond;
    }

    void setLogDeleteCheckIntervalSecond(int logDeleteCheckIntervalSecond) {
        this.logDeleteCheckIntervalSecond = logDeleteCheckIntervalSecond;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public boolean isEnableAutoCreateSchema() {
        return this.enableAutoCreateSchema;
    }

    public void setEnableAutoCreateSchema(boolean enableAutoCreateSchema) {
        this.enableAutoCreateSchema = enableAutoCreateSchema;
    }

    public boolean isUseAsyncServer() {
        return this.useAsyncServer;
    }

    public void setUseAsyncServer(boolean useAsyncServer) {
        this.useAsyncServer = useAsyncServer;
    }

    public boolean isEnableRaftLogPersistence() {
        return this.enableRaftLogPersistence;
    }

    public void setEnableRaftLogPersistence(boolean enableRaftLogPersistence) {
        this.enableRaftLogPersistence = enableRaftLogPersistence;
    }

    public boolean isUseAsyncApplier() {
        return this.useAsyncApplier;
    }

    public void setUseAsyncApplier(boolean useAsyncApplier) {
        this.useAsyncApplier = useAsyncApplier;
    }

    public int getMaxNumOfLogsInMem() {
        return this.maxNumOfLogsInMem;
    }

    public void setMaxNumOfLogsInMem(int maxNumOfLogsInMem) {
        this.maxNumOfLogsInMem = maxNumOfLogsInMem;
    }

    public int getUnCommittedRaftLogNumForRejectThreshold() {
        return this.UnCommittedRaftLogNumForRejectThreshold;
    }

    public void setUnCommittedRaftLogNumForRejectThreshold(int unCommittedRaftLogNumForRejectThreshold) {
        this.UnCommittedRaftLogNumForRejectThreshold = unCommittedRaftLogNumForRejectThreshold;
    }

    public int getUnAppliedRaftLogNumForRejectThreshold() {
        return this.UnAppliedRaftLogNumForRejectThreshold;
    }

    public void setUnAppliedRaftLogNumForRejectThreshold(int unAppliedRaftLogNumForRejectThreshold) {
        this.UnAppliedRaftLogNumForRejectThreshold = unAppliedRaftLogNumForRejectThreshold;
    }

    public int getRaftLogBufferSize() {
        return this.raftLogBufferSize;
    }

    public void setRaftLogBufferSize(int raftLogBufferSize) {
        this.raftLogBufferSize = raftLogBufferSize;
    }

    public int getFlushRaftLogThreshold() {
        return this.flushRaftLogThreshold;
    }

    void setFlushRaftLogThreshold(int flushRaftLogThreshold) {
        this.flushRaftLogThreshold = flushRaftLogThreshold;
    }

    public long getJoinClusterTimeOutMs() {
        return this.joinClusterTimeOutMs;
    }

    public void setJoinClusterTimeOutMs(long joinClusterTimeOutMs) {
        this.joinClusterTimeOutMs = joinClusterTimeOutMs;
    }

    public int getPullSnapshotRetryIntervalMs() {
        return this.pullSnapshotRetryIntervalMs;
    }

    public void setPullSnapshotRetryIntervalMs(int pullSnapshotRetryIntervalMs) {
        this.pullSnapshotRetryIntervalMs = pullSnapshotRetryIntervalMs;
    }

    public int getMaxRaftLogIndexSizeInMemory() {
        return this.maxRaftLogIndexSizeInMemory;
    }

    public void setMaxRaftLogIndexSizeInMemory(int maxRaftLogIndexSizeInMemory) {
        this.maxRaftLogIndexSizeInMemory = maxRaftLogIndexSizeInMemory;
    }

    public long getMaxMemorySizeForRaftLog() {
        return this.maxMemorySizeForRaftLog;
    }

    public void setMaxMemorySizeForRaftLog(long maxMemorySizeForRaftLog) {
        this.maxMemorySizeForRaftLog = maxMemorySizeForRaftLog;
    }

    public double getRaftLogMemoryProportion() {
        return this.RaftLogMemoryProportion;
    }

    public void setRaftLogMemoryProportion(double raftLogMemoryProportion) {
        this.RaftLogMemoryProportion = raftLogMemoryProportion;
    }

    public int getMaxRaftLogPersistDataSizePerFile() {
        return this.maxRaftLogPersistDataSizePerFile;
    }

    public void setMaxRaftLogPersistDataSizePerFile(int maxRaftLogPersistDataSizePerFile) {
        this.maxRaftLogPersistDataSizePerFile = maxRaftLogPersistDataSizePerFile;
    }

    public int getMaxNumberOfPersistRaftLogFiles() {
        return this.maxNumberOfPersistRaftLogFiles;
    }

    public void setMaxNumberOfPersistRaftLogFiles(int maxNumberOfPersistRaftLogFiles) {
        this.maxNumberOfPersistRaftLogFiles = maxNumberOfPersistRaftLogFiles;
    }

    public int getMaxPersistRaftLogNumberOnDisk() {
        return this.maxPersistRaftLogNumberOnDisk;
    }

    public void setMaxPersistRaftLogNumberOnDisk(int maxPersistRaftLogNumberOnDisk) {
        this.maxPersistRaftLogNumberOnDisk = maxPersistRaftLogNumberOnDisk;
    }

    public boolean isEnableUsePersistLogOnDiskToCatchUp() {
        return this.enableUsePersistLogOnDiskToCatchUp;
    }

    public void setEnableUsePersistLogOnDiskToCatchUp(boolean enableUsePersistLogOnDiskToCatchUp) {
        this.enableUsePersistLogOnDiskToCatchUp = enableUsePersistLogOnDiskToCatchUp;
    }

    public int getMaxNumberOfLogsPerFetchOnDisk() {
        return this.maxNumberOfLogsPerFetchOnDisk;
    }

    public void setMaxNumberOfLogsPerFetchOnDisk(int maxNumberOfLogsPerFetchOnDisk) {
        this.maxNumberOfLogsPerFetchOnDisk = maxNumberOfLogsPerFetchOnDisk;
    }

    public boolean isWaitForSlowNode() {
        return this.waitForSlowNode;
    }

    public long getMaxReadLogLag() {
        return this.maxReadLogLag;
    }

    public void setMaxReadLogLag(long maxReadLogLag) {
        this.maxReadLogLag = maxReadLogLag;
    }

    public long getMaxSyncLogLag() {
        return this.maxSyncLogLag;
    }

    public void setMaxSyncLogLag(long maxSyncLogLag) {
        this.maxSyncLogLag = maxSyncLogLag;
    }

    public String getInternalIp() {
        return this.internalIp;
    }

    public void setInternalIp(String internalIp) {
        this.internalIp = internalIp;
    }

    public boolean isOpenServerRpcPort() {
        return this.openServerRpcPort;
    }

    public void setOpenServerRpcPort(boolean openServerRpcPort) {
        this.openServerRpcPort = openServerRpcPort;
    }

    public long getWaitClientTimeoutMS() {
        return this.waitClientTimeoutMS;
    }

    public void setWaitClientTimeoutMS(long waitClientTimeoutMS) {
        this.waitClientTimeoutMS = waitClientTimeoutMS;
    }

    public long getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setHeartbeatIntervalMs(long heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public long getElectionTimeoutMs() {
        return this.electionTimeoutMs;
    }

    public void setElectionTimeoutMs(long electionTimeoutMs) {
        this.electionTimeoutMs = electionTimeoutMs;
    }

    public int getClusterInfoRpcPort() {
        return this.clusterInfoRpcPort;
    }

    public void setClusterInfoRpcPort(int clusterInfoRpcPort) {
        this.clusterInfoRpcPort = clusterInfoRpcPort;
    }
}

