/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.util.FileOutputSignalHandler;
import org.apache.ignite3.raft.jraft.util.MetricReporter;
import org.apache.ignite3.raft.jraft.util.SystemPropertyUtil;
import org.apache.ignite3.raft.jraft.util.ThreadPoolMetricRegistry;

public class ThreadPoolMetricsSignalHandler
extends FileOutputSignalHandler {
    private static IgniteLogger LOG = Loggers.forClass(ThreadPoolMetricsSignalHandler.class);
    private static final String DIR = SystemPropertyUtil.get("jraft.signal.thread.pool.metrics.dir", "");
    private static final String BASE_NAME = "thread_pool_metrics.log";

    @Override
    public void handle(String signalName) {
        try {
            File file = this.getOutputFile(DIR, BASE_NAME);
            LOG.info("Printing thread pools metrics with signal: {} to file: {}.", signalName, file);
            try (PrintStream out = new PrintStream(new FileOutputStream(file, true));){
                MetricReporter.forRegistry(ThreadPoolMetricRegistry.metricRegistry()).outputTo(out).build().report();
            }
        }
        catch (IOException e) {
            LOG.error("Fail to print thread pools metrics.", (Throwable)e);
        }
    }
}

