/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.compute.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.compute.exception.ComputeJobNotFoundException;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;

@Singleton
@Requires(classes={ComputeJobNotFoundExceptionHandler.class, ExceptionHandler.class})
public class ComputeJobNotFoundExceptionHandler
implements ExceptionHandler<ComputeJobNotFoundException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, ComputeJobNotFoundException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.NOT_FOUND).detail(exception.getMessage()).build());
    }
}

