/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft;

import java.util.Objects;
import org.apache.ignite3.internal.raft.Peer;
import org.apache.ignite3.internal.raft.StoredRaftNodeId;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.tostring.S;

public class RaftNodeId {
    private static final String PEER_INDEX_DELIMITER = "-";
    private final ReplicationGroupId groupId;
    private final Peer peer;

    public RaftNodeId(ReplicationGroupId groupId, Peer peer) {
        this.groupId = groupId;
        this.peer = Objects.requireNonNull(peer);
    }

    public String nodeIdStringForStorage() {
        return this.groupId().toString() + PEER_INDEX_DELIMITER + this.peer().idx();
    }

    public static StoredRaftNodeId fromNodeIdStringForStorage(String nodeIdStr, String localNodeConsistentId) {
        int separatorIndex = nodeIdStr.lastIndexOf(PEER_INDEX_DELIMITER);
        int peerIndex = Integer.parseInt(nodeIdStr.substring(separatorIndex + PEER_INDEX_DELIMITER.length()));
        Peer peer = new Peer(localNodeConsistentId, peerIndex);
        return new StoredRaftNodeId(nodeIdStr.substring(0, separatorIndex), peer);
    }

    public ReplicationGroupId groupId() {
        return this.groupId;
    }

    public Peer peer() {
        return this.peer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaftNodeId that = (RaftNodeId)o;
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        return this.peer.equals(that.peer);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.peer.hashCode();
        return result;
    }

    public String toString() {
        return S.toString(RaftNodeId.class, this);
    }
}

