/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.sql;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlResultSet;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.async.AsyncResultSet;

public class ClientSqlCursorNextPageRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, ClientResourceRegistry resources) throws IgniteInternalCheckedException {
        long resourceId = in.unpackLong();
        ClientSqlResultSet resultSet = resources.get(resourceId).get(ClientSqlResultSet.class);
        return ((CompletableFuture)resultSet.resultSet().fetchNextPage().thenCompose(r -> {
            if (!r.hasMorePages()) {
                try {
                    resources.remove(resourceId);
                }
                catch (IgniteInternalCheckedException igniteInternalCheckedException) {
                    // empty catch block
                }
                return resultSet.closeAsync().thenApply(v -> ClientSqlCursorNextPageRequest.getResponseWriter(r));
            }
            return CompletableFuture.completedFuture(ClientSqlCursorNextPageRequest.getResponseWriter(r));
        })).toCompletableFuture();
    }

    private static ResponseWriter getResponseWriter(AsyncResultSet<SqlRow> r) {
        return out -> {
            ClientSqlCommon.packCurrentPage(out, r);
            out.packBoolean(r.hasMorePages());
        };
    }
}

