/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.jdbc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.cache.CacheException;
import javax.cache.integration.CacheLoaderException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.store.jdbc.CacheAbstractJdbcStore;
import org.apache.ignite.cache.store.jdbc.JdbcType;
import org.apache.ignite.cache.store.jdbc.JdbcTypeField;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheJdbcPojoStore<K, V>
extends CacheAbstractJdbcStore<K, V> {
    private volatile Map<String, Map<String, PojoPropertiesCache>> pojosProps = Collections.emptyMap();

    @Override
    @Nullable
    protected Object extractParameter(@Nullable String cacheName, String typeName, CacheAbstractJdbcStore.TypeKind typeKind, String fldName, Object obj) throws CacheException {
        switch (typeKind) {
            case BUILT_IN: {
                return obj;
            }
            case POJO: {
                return this.extractPojoParameter(cacheName, typeName, fldName, obj);
            }
        }
        return this.extractBinaryParameter(fldName, obj);
    }

    @Nullable
    private Object extractPojoParameter(@Nullable String cacheName, String typeName, String fldName, Object obj) throws CacheException {
        try {
            Map<String, PojoPropertiesCache> cacheProps = this.pojosProps.get(cacheName);
            if (cacheProps == null) {
                throw new CacheException("Failed to find POJO type metadata for cache: " + U.maskName(cacheName));
            }
            PojoPropertiesCache ppc = cacheProps.get(typeName);
            if (ppc == null) {
                throw new CacheException("Failed to find POJO type metadata for type: " + typeName);
            }
            ClassProperty prop = ppc.props.get(fldName);
            if (prop == null) {
                throw new CacheLoaderException("Failed to find property in POJO class [class=" + typeName + ", prop=" + fldName + "]");
            }
            return prop.get(obj);
        }
        catch (Exception e) {
            throw new CacheException("Failed to read object property [cache=" + U.maskName(cacheName) + ", type=" + typeName + ", prop=" + fldName + "]", (Throwable)e);
        }
    }

    private Object extractBinaryParameter(String fieldName, Object obj) throws CacheException {
        if (obj instanceof BinaryObject) {
            return ((BinaryObject)obj).field(fieldName);
        }
        throw new CacheException("Failed to read property value from non binary object [class=" + obj.getClass() + ", property=" + fieldName + "]");
    }

    @Override
    protected <R> R buildObject(@Nullable String cacheName, String typeName, CacheAbstractJdbcStore.TypeKind typeKind, JdbcTypeField[] flds, Map<String, Integer> loadColIdxs, ResultSet rs) throws CacheLoaderException {
        switch (typeKind) {
            case BUILT_IN: {
                return (R)this.buildBuiltinObject(typeName, flds, loadColIdxs, rs);
            }
            case POJO: {
                return (R)this.buildPojoObject(cacheName, typeName, flds, loadColIdxs, rs);
            }
        }
        return (R)this.buildBinaryObject(typeName, flds, loadColIdxs, rs);
    }

    private Object buildBuiltinObject(String typeName, JdbcTypeField[] fields, Map<String, Integer> loadColIdxs, ResultSet rs) throws CacheLoaderException {
        JdbcTypeField field = fields[0];
        try {
            Integer colIdx = this.columnIndex(loadColIdxs, field.getDatabaseFieldName());
            return this.transformer.getColumnValue(rs, colIdx, field.getJavaFieldType());
        }
        catch (SQLException e) {
            throw new CacheLoaderException("Failed to read object: [cls=" + typeName + ", prop=" + field + "]", (Throwable)e);
        }
    }

    private Object buildPojoObject(@Nullable String cacheName, String typeName, JdbcTypeField[] flds, Map<String, Integer> loadColIdxs, ResultSet rs) throws CacheLoaderException {
        Map<String, PojoPropertiesCache> cacheProps = this.pojosProps.get(cacheName);
        if (cacheProps == null) {
            throw new CacheLoaderException("Failed to find POJO types metadata for cache: " + U.maskName(cacheName));
        }
        PojoPropertiesCache ppc = cacheProps.get(typeName);
        if (ppc == null) {
            throw new CacheLoaderException("Failed to find POJO type metadata for type: " + typeName);
        }
        try {
            Object obj = ppc.ctor.newInstance(new Object[0]);
            for (JdbcTypeField fld : flds) {
                String fldJavaName = fld.getJavaFieldName();
                ClassProperty prop = ppc.props.get(fldJavaName);
                if (prop == null) {
                    throw new IllegalStateException("Failed to find property in POJO class [type=" + typeName + ", prop=" + fldJavaName + "]");
                }
                String dbName = fld.getDatabaseFieldName();
                Integer colIdx = this.columnIndex(loadColIdxs, dbName);
                try {
                    Object colVal = this.transformer.getColumnValue(rs, colIdx, fld.getJavaFieldType());
                    try {
                        prop.set(obj, colVal);
                    }
                    catch (Exception e) {
                        throw new CacheLoaderException("Failed to set property in POJO class [type=" + typeName + ", colIdx=" + colIdx + ", prop=" + fld + ", dbValCls=" + colVal.getClass().getName() + ", dbVal=" + colVal + "]", (Throwable)e);
                    }
                }
                catch (SQLException e) {
                    throw new CacheLoaderException("Failed to read object property [type=" + typeName + ", colIdx=" + colIdx + ", prop=" + fld + "]", (Throwable)e);
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new CacheLoaderException("Failed to construct instance of class: " + typeName, (Throwable)e);
        }
    }

    protected Object buildBinaryObject(String typeName, JdbcTypeField[] fields, Map<String, Integer> loadColIdxs, ResultSet rs) throws CacheLoaderException {
        try {
            BinaryObjectBuilder builder = this.ignite.binary().builder(typeName);
            for (JdbcTypeField field : fields) {
                Integer colIdx = this.columnIndex(loadColIdxs, field.getDatabaseFieldName());
                Object colVal = this.transformer.getColumnValue(rs, colIdx, field.getJavaFieldType());
                builder.setField(field.getJavaFieldName(), colVal, field.getJavaFieldType());
            }
            return builder.build();
        }
        catch (SQLException e) {
            throw new CacheException("Failed to read binary object: " + typeName, (Throwable)e);
        }
    }

    @Override
    protected Object typeIdForObject(Object obj) throws CacheException {
        if (obj instanceof BinaryObject) {
            return ((BinaryObjectEx)obj).typeId();
        }
        return obj.getClass();
    }

    @Override
    protected Object typeIdForTypeName(CacheAbstractJdbcStore.TypeKind kind, String typeName) throws CacheException {
        if (kind == CacheAbstractJdbcStore.TypeKind.BINARY) {
            return this.ignite.binary().typeId(typeName);
        }
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Failed to find class: " + typeName, (Throwable)e);
        }
    }

    @Override
    protected void prepareBuilders(@Nullable String cacheName, Collection<JdbcType> types) throws CacheException {
        HashMap<String, PojoPropertiesCache> pojoProps = U.newHashMap(types.size() * 2);
        for (JdbcType type : types) {
            String valTypeName;
            CacheAbstractJdbcStore.TypeKind valKind;
            String keyTypeName = type.getKeyType();
            CacheAbstractJdbcStore.TypeKind keyKind = this.kindForName(keyTypeName);
            if (keyKind == CacheAbstractJdbcStore.TypeKind.POJO) {
                if (pojoProps.containsKey(keyTypeName)) {
                    throw new CacheException("Found duplicate key type [cache=" + U.maskName(cacheName) + ", keyType=" + keyTypeName + "]");
                }
                pojoProps.put(keyTypeName, new PojoPropertiesCache(keyTypeName, type.getKeyFields()));
            }
            if ((valKind = this.kindForName(valTypeName = type.getValueType())) != CacheAbstractJdbcStore.TypeKind.POJO) continue;
            pojoProps.put(valTypeName, new PojoPropertiesCache(valTypeName, type.getValueFields()));
        }
        if (!pojoProps.isEmpty()) {
            HashMap<String, Map<String, PojoPropertiesCache>> newPojosProps = new HashMap<String, Map<String, PojoPropertiesCache>>(this.pojosProps);
            newPojosProps.put(cacheName, pojoProps);
            this.pojosProps = newPojosProps;
        }
    }

    public String toString() {
        return S.toString(CacheJdbcPojoStore.class, this);
    }

    private static class PojoPropertiesCache {
        private final Class<?> cls;
        private Constructor ctor;
        private Map<String, ClassProperty> props;

        private PojoPropertiesCache(String clsName, JdbcTypeField[] jdbcFlds) throws CacheException {
            try {
                this.cls = Class.forName(clsName);
                this.ctor = this.cls.getDeclaredConstructor(new Class[0]);
                if (!this.ctor.isAccessible()) {
                    this.ctor.setAccessible(true);
                }
            }
            catch (ClassNotFoundException e) {
                throw new CacheException("Failed to find class: " + clsName, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new CacheException("Failed to find default constructor for class: " + clsName, (Throwable)e);
            }
            this.props = U.newHashMap(jdbcFlds.length);
            for (JdbcTypeField jdbcFld : jdbcFlds) {
                Method setter;
                String fldName = jdbcFld.getJavaFieldName();
                String mthName = this.capitalFirst(fldName);
                Method getter = this.methodByName(this.cls, "get" + mthName, new Class[0]);
                if (getter == null) {
                    getter = this.methodByName(this.cls, "is" + mthName, new Class[0]);
                }
                if (getter == null) {
                    getter = this.methodByName(this.cls, fldName, new Class[0]);
                }
                if ((setter = this.methodByName(this.cls, "set" + mthName, jdbcFld.getJavaFieldType())) == null) {
                    setter = this.methodByName(this.cls, fldName, jdbcFld.getJavaFieldType());
                }
                if (getter != null && setter != null) {
                    this.props.put(fldName, new ClassProperty(getter, setter, null));
                    continue;
                }
                try {
                    this.props.put(fldName, new ClassProperty(null, null, this.cls.getDeclaredField(fldName)));
                }
                catch (NoSuchFieldException ignored) {
                    throw new CacheException("Failed to find property in POJO class [class=" + clsName + ", prop=" + fldName + "]");
                }
            }
        }

        @Nullable
        private String capitalFirst(@Nullable String str) {
            return str == null ? null : (str.isEmpty() ? "" : Character.toUpperCase(str.charAt(0)) + str.substring(1));
        }

        private Method methodByName(Class<?> cls, String name, Class<?> ... paramTypes) {
            try {
                return cls.getMethod(name, paramTypes);
            }
            catch (NoSuchMethodException ignored) {
                return null;
            }
        }
    }

    private static class ClassProperty {
        private final Method getter;
        private final Method setter;
        private final Field field;

        private ClassProperty(Method getter, Method setter, Field field) {
            this.getter = getter;
            this.setter = setter;
            this.field = field;
            if (getter != null) {
                getter.setAccessible(true);
            }
            if (setter != null) {
                setter.setAccessible(true);
            }
            if (field != null) {
                field.setAccessible(true);
            }
        }

        private Object get(Object obj) throws IllegalAccessException, InvocationTargetException {
            if (this.getter != null) {
                return this.getter.invoke(obj, new Object[0]);
            }
            if (this.field != null) {
                return this.field.get(obj);
            }
            throw new IllegalAccessException("Failed to get value from property. Getter and field was not initialized.");
        }

        private void set(Object obj, Object val) throws IllegalAccessException, InvocationTargetException {
            if (this.setter != null) {
                this.setter.invoke(obj, val);
            } else if (this.field != null) {
                this.field.set(obj, val);
            } else {
                throw new IllegalAccessException("Failed to set new value from property.  Setter and field was not initialized.");
            }
        }
    }
}

