/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.util.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class ByteUtils {
    public static long bytesToLong(byte[] bytes, int off) {
        assert (bytes != null);
        int bytesCount = Math.min(8, bytes.length - off);
        long res = 0L;
        for (int i = 0; i < bytesCount; ++i) {
            res = res << 8 | 0xFFL & (long)bytes[off + i];
        }
        return res;
    }

    public static long bytesToLong(byte[] bytes) {
        return ByteUtils.bytesToLong(bytes, 0);
    }

    public static long bytesToLongKeepingOrder(byte[] bytes) {
        return ByteUtils.bytesToLong(bytes) ^ 0x80808080808080L;
    }

    public static byte[] longToBytes(long l) {
        return ByteUtils.putLongToBytes(l, new byte[8], 0);
    }

    public static byte[] longToBytesKeepingOrder(long l) {
        return ByteUtils.longToBytes(l ^ 0x80808080808080L);
    }

    public static byte[] putLongToBytes(long l, byte[] bytes, int off) {
        assert (bytes != null);
        assert (bytes.length >= off + 8);
        for (int i = 7; i >= 0; --i) {
            bytes[off + i] = (byte)l;
            l >>>= 8;
        }
        return bytes;
    }

    public static int bytesToInt(byte[] bytes, int off) {
        assert (bytes != null);
        int bytesCount = Math.min(4, bytes.length - off);
        int res = 0;
        for (int i = 0; i < bytesCount; ++i) {
            res = res << 8 | 0xFF & bytes[off + i];
        }
        return res;
    }

    public static int bytesToInt(byte[] bytes) {
        return ByteUtils.bytesToInt(bytes, 0);
    }

    public static int bytesToIntKeepingOrder(byte[] bytes) {
        return ByteUtils.bytesToInt(bytes) ^ 0x808080;
    }

    public static short bytesToShort(byte[] bytes, int off) {
        assert (bytes != null);
        int bytesCount = Math.min(2, bytes.length - off);
        int res = 0;
        for (int i = 0; i < bytesCount; ++i) {
            res = res << 8 | 0xFF & bytes[off + i];
        }
        return (short)res;
    }

    public static byte[] intToBytes(int i) {
        return ByteUtils.putIntToBytes(i, new byte[4], 0);
    }

    public static byte[] intToBytesKeepingOrder(int i) {
        return ByteUtils.intToBytes(i ^ 0x808080);
    }

    public static byte[] putIntToBytes(int i, byte[] bytes, int off) {
        ByteUtils.putToBytes(i, 4, bytes, off);
        return bytes;
    }

    public static byte[] putShortToBytes(short s, byte[] bytes, int off) {
        ByteUtils.putToBytes(s, 2, bytes, off);
        return bytes;
    }

    private static void putToBytes(long value, int sizeInBytes, byte[] bytes, int off) {
        assert (bytes != null);
        assert (off + sizeInBytes <= bytes.length);
        for (int k = sizeInBytes - 1; k >= 0; --k) {
            bytes[off + k] = (byte)value;
            value >>>= 8;
        }
    }

    public static byte booleanToByte(boolean val) {
        return (byte)(val ? 1 : 0);
    }

    public static boolean byteToBoolean(byte val) {
        if (val == 1) {
            return true;
        }
        assert (val == 0) : "Unexpected " + val;
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(Object obj) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(obj);
                out.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new IgniteInternalException(String.format("Could not serialize a class [cls=%s]", obj.getClass()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromBytes(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                object = in.readObject();
            }
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IgniteInternalException("Could not deserialize an object", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromBytes(byte[] bytes, int from, int length) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes, from, length);){
            Object object;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                object = in.readObject();
            }
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IgniteInternalException("Could not deserialize an object", (Throwable)e);
        }
    }

    public static byte @Nullable [] stringToBytes(@Nullable String s) {
        return s == null ? null : s.getBytes(StandardCharsets.UTF_8);
    }

    @Nullable
    public static String stringFromBytes(byte @Nullable [] bytes) {
        return bytes == null ? null : new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining == 0) {
            return ArrayUtils.BYTE_EMPTY_ARRAY;
        }
        byte[] bytes = new byte[remaining];
        buffer.get(bytes);
        buffer.flip();
        return bytes;
    }

    public static List<byte[]> toByteArrayList(List<ByteBuffer> byteBufferList) {
        if (byteBufferList.isEmpty()) {
            return List.of();
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(byteBufferList.size());
        for (int i = 0; i < byteBufferList.size(); ++i) {
            result.add(ByteUtils.toByteArray(byteBufferList.get(i)));
        }
        return Collections.unmodifiableList(result);
    }

    public static byte[] uuidToBytes(UUID uuid) {
        byte[] bytes = new byte[16];
        ByteUtils.putLongToBytes(uuid.getMostSignificantBits(), bytes, 0);
        ByteUtils.putLongToBytes(uuid.getLeastSignificantBits(), bytes, 8);
        return bytes;
    }

    public static UUID bytesToUuid(byte[] bytes) {
        return ByteUtils.bytesToUuid(bytes, 0);
    }

    public static UUID bytesToUuid(byte[] bytes, int offset) {
        long higher = ByteUtils.bytesToLong(bytes, offset);
        long lower = ByteUtils.bytesToLong(bytes, offset + 8);
        return new UUID(higher, lower);
    }
}

