/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.event;

import org.apache.ignite.internal.cli.core.repl.ConnectEvent;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.event.Event;
import org.apache.ignite.internal.cli.event.EventListener;

public interface ConnectionEventListener
extends EventListener {
    @Override
    default public void onEvent(Event event) {
        switch (event.eventType()) {
            case CONNECT: {
                ConnectEvent connectEvent = (ConnectEvent)event;
                this.onConnect(connectEvent.sessionInfo());
                break;
            }
            case DISCONNECT: {
                this.onDisconnect();
                break;
            }
            case CONNECTION_LOST: {
                this.onConnectionLost();
                break;
            }
            case CONNECTION_RESTORED: {
                this.onConnectionRestored();
                break;
            }
        }
    }

    default public void onConnect(SessionInfo sessionInfo) {
    }

    default public void onDisconnect() {
    }

    default public void onConnectionLost() {
    }

    default public void onConnectionRestored() {
    }
}

