/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.RowUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class Row
implements Serializable {
    private static final long serialVersionUID = 3L;
    private RowKind kind;
    @Nullable
    private final Object[] fieldByPosition;
    @Nullable
    private final Map<String, Object> fieldByName;
    @Nullable
    private final LinkedHashMap<String, Integer> positionByName;

    Row(RowKind kind, @Nullable Object[] fieldByPosition, @Nullable Map<String, Object> fieldByName, @Nullable LinkedHashMap<String, Integer> positionByName) {
        this.kind = kind;
        this.fieldByPosition = fieldByPosition;
        this.fieldByName = fieldByName;
        this.positionByName = positionByName;
    }

    public Row(RowKind kind, int arity) {
        this.kind = Preconditions.checkNotNull(kind, "Row kind must not be null.");
        this.fieldByPosition = new Object[arity];
        this.fieldByName = null;
        this.positionByName = null;
    }

    public Row(int arity) {
        this(RowKind.INSERT, arity);
    }

    public static Row withPositions(RowKind kind, int arity) {
        return new Row(kind, new Object[arity], null, null);
    }

    public static Row withPositions(int arity) {
        return Row.withPositions(RowKind.INSERT, arity);
    }

    public static Row withNames(RowKind kind) {
        return new Row(kind, null, new HashMap<String, Object>(), null);
    }

    public static Row withNames() {
        return Row.withNames(RowKind.INSERT);
    }

    public RowKind getKind() {
        return this.kind;
    }

    public void setKind(RowKind kind) {
        Preconditions.checkNotNull(kind, "Row kind must not be null.");
        this.kind = kind;
    }

    public int getArity() {
        if (this.fieldByPosition != null) {
            return this.fieldByPosition.length;
        }
        assert (this.fieldByName != null);
        return this.fieldByName.size();
    }

    @Nullable
    public Object getField(int pos) {
        if (this.fieldByPosition != null) {
            return this.fieldByPosition[pos];
        }
        throw new IllegalArgumentException("Accessing a field by position is not supported in name-based field mode.");
    }

    public <T> T getFieldAs(int pos) {
        return (T)this.getField(pos);
    }

    @Nullable
    public Object getField(String name) {
        if (this.fieldByName != null) {
            return this.fieldByName.get(name);
        }
        if (this.positionByName != null) {
            Integer pos = this.positionByName.get(name);
            if (pos == null) {
                throw new IllegalArgumentException(String.format("Unknown field name '%s' for mapping to a position.", name));
            }
            assert (this.fieldByPosition != null);
            return this.fieldByPosition[pos];
        }
        throw new IllegalArgumentException("Accessing a field by name is not supported in position-based field mode.");
    }

    public <T> T getFieldAs(String name) {
        return (T)this.getField(name);
    }

    public void setField(int pos, @Nullable Object value) {
        if (this.fieldByPosition == null) {
            throw new IllegalArgumentException("Accessing a field by position is not supported in name-based field mode.");
        }
        this.fieldByPosition[pos] = value;
    }

    public void setField(String name, @Nullable Object value) {
        if (this.fieldByName != null) {
            this.fieldByName.put(name, value);
        } else if (this.positionByName != null) {
            Integer pos = this.positionByName.get(name);
            if (pos == null) {
                throw new IllegalArgumentException(String.format("Unknown field name '%s' for mapping to a row position. Available names are: %s", name, this.positionByName.keySet()));
            }
            assert (this.fieldByPosition != null);
            this.fieldByPosition[pos.intValue()] = value;
        } else {
            throw new IllegalArgumentException("Accessing a field by name is not supported in position-based field mode.");
        }
    }

    @Nullable
    public Set<String> getFieldNames(boolean includeNamedPositions) {
        if (this.fieldByName != null) {
            return this.fieldByName.keySet();
        }
        if (includeNamedPositions && this.positionByName != null) {
            return this.positionByName.keySet();
        }
        return null;
    }

    public void clear() {
        if (this.fieldByPosition != null) {
            Arrays.fill(this.fieldByPosition, null);
        } else {
            assert (this.fieldByName != null);
            this.fieldByName.clear();
        }
    }

    public String toString() {
        return RowUtils.deepToStringRow(this.kind, this.fieldByPosition, this.fieldByName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row other = (Row)o;
        return RowUtils.deepEqualsRow(this.kind, this.fieldByPosition, this.fieldByName, this.positionByName, other.kind, other.fieldByPosition, other.fieldByName, other.positionByName);
    }

    public int hashCode() {
        return RowUtils.deepHashCodeRow(this.kind, this.fieldByPosition, this.fieldByName);
    }

    public static Row of(Object ... values) {
        Row row = new Row(values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }

    public static Row ofKind(RowKind kind, Object ... values) {
        Row row = new Row(kind, values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setField(i, values[i]);
        }
        return row;
    }

    public static Row copy(Row row) {
        Object[] newFieldByPosition;
        if (row.fieldByPosition != null) {
            newFieldByPosition = new Object[row.fieldByPosition.length];
            System.arraycopy(row.fieldByPosition, 0, newFieldByPosition, 0, newFieldByPosition.length);
        } else {
            newFieldByPosition = null;
        }
        HashMap<String, Object> newFieldByName = row.fieldByName != null ? new HashMap<String, Object>(row.fieldByName) : null;
        return new Row(row.kind, newFieldByPosition, newFieldByName, row.positionByName);
    }

    public static Row project(Row row, int[] fieldPositions) {
        Row newRow = Row.withPositions(row.kind, fieldPositions.length);
        for (int i = 0; i < fieldPositions.length; ++i) {
            newRow.setField(i, row.getField(fieldPositions[i]));
        }
        return newRow;
    }

    public static Row project(Row row, String[] fieldNames) {
        Row newRow = Row.withNames(row.getKind());
        for (String fieldName : fieldNames) {
            newRow.setField(fieldName, row.getField(fieldName));
        }
        return newRow;
    }

    public static Row join(Row first, Row ... remainings) {
        Preconditions.checkArgument(first.fieldByPosition != null, "All rows must operate in position-based field mode.");
        int newLength = first.fieldByPosition.length;
        for (Row remaining : remainings) {
            Preconditions.checkArgument(remaining.fieldByPosition != null, "All rows must operate in position-based field mode.");
            newLength += remaining.fieldByPosition.length;
        }
        Row joinedRow = new Row(first.kind, newLength);
        int index = 0;
        assert (joinedRow.fieldByPosition != null);
        System.arraycopy(first.fieldByPosition, 0, joinedRow.fieldByPosition, index, first.fieldByPosition.length);
        index += first.fieldByPosition.length;
        for (Row remaining : remainings) {
            assert (remaining.fieldByPosition != null);
            System.arraycopy(remaining.fieldByPosition, 0, joinedRow.fieldByPosition, index, remaining.fieldByPosition.length);
            index += remaining.fieldByPosition.length;
        }
        return joinedRow;
    }
}

