/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.sql.Date;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;

@PublicEvolving
public final class DateType
extends LogicalType {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT = "DATE";
    private static final Set<String> NULL_OUTPUT_CONVERSION = DateType.conversionSet(Date.class.getName(), LocalDate.class.getName(), Integer.class.getName());
    private static final Set<String> NOT_NULL_INPUT_OUTPUT_CONVERSION = DateType.conversionSet(Date.class.getName(), LocalDate.class.getName(), Integer.class.getName(), Integer.TYPE.getName());
    private static final Class<?> DEFAULT_CONVERSION = LocalDate.class;

    public DateType(boolean isNullable) {
        super(isNullable, LogicalTypeRoot.DATE);
    }

    public DateType() {
        this(true);
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new DateType(isNullable);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, new Object[0]);
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        if (this.isNullable()) {
            return NULL_OUTPUT_CONVERSION.contains(clazz.getName());
        }
        return NOT_NULL_INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

