/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import java.util.List;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.operation.FileStoreWrite;
import org.apache.flink.table.store.table.sink.FileCommittable;
import org.apache.flink.table.store.table.sink.SinkRecord;
import org.apache.flink.table.store.table.sink.SinkRecordConverter;
import org.apache.flink.table.store.table.sink.TableWrite;

public class TableWriteImpl<T>
implements TableWrite {
    private final FileStoreWrite<T> write;
    private final SinkRecordConverter recordConverter;
    private final RecordExtractor<T> recordExtractor;

    public TableWriteImpl(FileStoreWrite<T> write, SinkRecordConverter recordConverter, RecordExtractor<T> recordExtractor) {
        this.write = write;
        this.recordConverter = recordConverter;
        this.recordExtractor = recordExtractor;
    }

    @Override
    public TableWrite withOverwrite(boolean overwrite) {
        this.write.withOverwrite(overwrite);
        return this;
    }

    @Override
    public TableWrite withIOManager(IOManager ioManager) {
        this.write.withIOManager(ioManager);
        return this;
    }

    @Override
    public SinkRecord write(RowData rowData) throws Exception {
        SinkRecord record = this.recordConverter.convert(rowData);
        this.write.write(record.partition(), record.bucket(), this.recordExtractor.extract(record));
        return record;
    }

    @Override
    public SinkRecord toLogRecord(SinkRecord record) {
        return this.recordConverter.convertToLogSinkRecord(record);
    }

    @Override
    public void compact(BinaryRowData partition, int bucket, boolean fullCompaction) throws Exception {
        this.write.compact(partition, bucket, fullCompaction);
    }

    @Override
    public void notifyNewFiles(long snapshotId, BinaryRowData partition, int bucket, List<DataFileMeta> files) {
        this.write.notifyNewFiles(snapshotId, partition, bucket, files);
    }

    @Override
    public List<FileCommittable> prepareCommit(boolean blocking, long commitIdentifier) throws Exception {
        return this.write.prepareCommit(blocking, commitIdentifier);
    }

    @Override
    public void close() throws Exception {
        this.write.close();
    }

    public static interface RecordExtractor<T> {
        public T extract(SinkRecord var1);
    }
}

