/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.hadoop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.flink.table.store.shaded.org.apache.parquet.internal.filter2.columnindex.RowRanges;
import shaded.parquet.it.unimi.dsi.fastutil.ints.IntArrayList;

class ColumnIndexFilterUtils {
    ColumnIndexFilterUtils() {
    }

    static OffsetIndex filterOffsetIndex(OffsetIndex offsetIndex, RowRanges rowRanges, long totalRowCount) {
        IntArrayList indexMap = new IntArrayList();
        int n = offsetIndex.getPageCount();
        for (int i = 0; i < n; ++i) {
            long from = offsetIndex.getFirstRowIndex(i);
            if (!rowRanges.isOverlapping(from, offsetIndex.getLastRowIndex(i, totalRowCount))) continue;
            indexMap.add(i);
        }
        return new FilteredOffsetIndex(offsetIndex, indexMap.toIntArray());
    }

    static List<OffsetRange> calculateOffsetRanges(OffsetIndex offsetIndex, ColumnChunkMetaData cm, long firstPageOffset) {
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        int n = offsetIndex.getPageCount();
        if (n > 0) {
            OffsetRange currentRange = null;
            long rowGroupOffset = cm.getStartingPos();
            if (rowGroupOffset < firstPageOffset) {
                currentRange = new OffsetRange(rowGroupOffset, (int)(firstPageOffset - rowGroupOffset));
                ranges.add(currentRange);
            }
            for (int i = 0; i < n; ++i) {
                long offset = offsetIndex.getOffset(i);
                int length = offsetIndex.getCompressedPageSize(i);
                if (currentRange != null && currentRange.extend(offset, length)) continue;
                currentRange = new OffsetRange(offset, length);
                ranges.add(currentRange);
            }
        }
        return ranges;
    }

    private static class FilteredOffsetIndex
    implements OffsetIndex {
        private final OffsetIndex offsetIndex;
        private final int[] indexMap;

        private FilteredOffsetIndex(OffsetIndex offsetIndex, int[] indexMap) {
            this.offsetIndex = offsetIndex;
            this.indexMap = indexMap;
        }

        @Override
        public int getPageOrdinal(int pageIndex) {
            return this.indexMap[pageIndex];
        }

        @Override
        public int getPageCount() {
            return this.indexMap.length;
        }

        @Override
        public long getOffset(int pageIndex) {
            return this.offsetIndex.getOffset(this.indexMap[pageIndex]);
        }

        @Override
        public int getCompressedPageSize(int pageIndex) {
            return this.offsetIndex.getCompressedPageSize(this.indexMap[pageIndex]);
        }

        @Override
        public long getFirstRowIndex(int pageIndex) {
            return this.offsetIndex.getFirstRowIndex(this.indexMap[pageIndex]);
        }

        @Override
        public long getLastRowIndex(int pageIndex, long totalRowCount) {
            int nextIndex = this.indexMap[pageIndex] + 1;
            return (nextIndex >= this.offsetIndex.getPageCount() ? totalRowCount : this.offsetIndex.getFirstRowIndex(nextIndex)) - 1L;
        }

        public String toString() {
            try (Formatter formatter = new Formatter();){
                formatter.format("%-12s  %20s  %16s  %20s\n", "", "offset", "compressed size", "first row index");
                int n = this.offsetIndex.getPageCount();
                for (int i = 0; i < n; ++i) {
                    int index = Arrays.binarySearch(this.indexMap, i);
                    boolean isHidden = index < 0;
                    formatter.format("%spage-%-5d  %20d  %16d  %20d\n", isHidden ? "- " : "  ", isHidden ? i : index, this.offsetIndex.getOffset(i), this.offsetIndex.getCompressedPageSize(i), this.offsetIndex.getFirstRowIndex(i));
                }
                String string = formatter.toString();
                return string;
            }
        }
    }

    static class OffsetRange {
        private final long offset;
        private long length;

        private OffsetRange(long offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        long getOffset() {
            return this.offset;
        }

        long getLength() {
            return this.length;
        }

        private boolean extend(long offset, int length) {
            if (this.offset + this.length == offset) {
                this.length += (long)length;
                return true;
            }
            return false;
        }
    }
}

