/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.Pool;
import org.apache.flink.connector.file.table.ColumnarRowIterator;
import org.apache.flink.connector.file.table.PartitionFieldExtractor;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.connector.format.FileBasedStatisticsReportableInputFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.columnar.ColumnarRowData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.VectorizedColumnBatch;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.ParquetVectorizedInputFormat;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.utils.ParquetFormatStatisticsReportUtil;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.utils.SerializableConfiguration;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.ColumnBatchFactory;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.ParquetSplitReaderUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public class ParquetColumnarRowInputFormat<SplitT extends FileSourceSplit>
extends ParquetVectorizedInputFormat<RowData, SplitT>
implements FileBasedStatisticsReportableInputFormat {
    private static final long serialVersionUID = 1L;
    private final TypeInformation<RowData> producedTypeInfo;

    public ParquetColumnarRowInputFormat(org.apache.hadoop.conf.Configuration hadoopConfig, RowType projectedType, TypeInformation<RowData> producedTypeInfo, int batchSize, boolean isUtcTimestamp, boolean isCaseSensitive) {
        this(hadoopConfig, projectedType, producedTypeInfo, ColumnBatchFactory.withoutExtraFields(), batchSize, isUtcTimestamp, isCaseSensitive);
    }

    ParquetColumnarRowInputFormat(org.apache.hadoop.conf.Configuration hadoopConfig, RowType projectedType, TypeInformation<RowData> producedTypeInfo, ColumnBatchFactory<SplitT> batchFactory, int batchSize, boolean isUtcTimestamp, boolean isCaseSensitive) {
        super(new SerializableConfiguration(hadoopConfig), projectedType, batchFactory, batchSize, isUtcTimestamp, isCaseSensitive);
        this.producedTypeInfo = producedTypeInfo;
    }

    @Override
    protected int numBatchesToCirculate(Configuration config) {
        return 1;
    }

    @Override
    protected ParquetVectorizedInputFormat.ParquetReaderBatch<RowData> createReaderBatch(WritableColumnVector[] writableVectors, VectorizedColumnBatch columnarBatch, Pool.Recycler<ParquetVectorizedInputFormat.ParquetReaderBatch<RowData>> recycler) {
        return new ColumnarRowReaderBatch(writableVectors, columnarBatch, recycler);
    }

    @Override
    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    @Override
    public TableStats reportStatistics(List<Path> files, DataType producedDataType) {
        return ParquetFormatStatisticsReportUtil.getTableStatistics(files, producedDataType, this.hadoopConfig.conf(), this.isUtcTimestamp);
    }

    public static <SplitT extends FileSourceSplit> ParquetColumnarRowInputFormat<SplitT> createPartitionedFormat(org.apache.hadoop.conf.Configuration hadoopConfig, RowType producedRowType, TypeInformation<RowData> producedTypeInfo, List<String> partitionKeys, PartitionFieldExtractor<SplitT> extractor, int batchSize, boolean isUtcTimestamp, boolean isCaseSensitive) {
        RowType projectedRowType = new RowType(producedRowType.getFields().stream().filter(field -> !partitionKeys.contains(field.getName())).collect(Collectors.toList()));
        List<String> projectedNames = projectedRowType.getFieldNames();
        ColumnBatchFactory<FileSourceSplit> factory = (split, parquetVectors) -> {
            ColumnVector[] vectors = new ColumnVector[producedRowType.getFieldCount()];
            for (int i = 0; i < vectors.length; ++i) {
                RowType.RowField field = producedRowType.getFields().get(i);
                vectors[i] = partitionKeys.contains(field.getName()) ? ParquetSplitReaderUtil.createVectorFromConstant(field.getType(), extractor.extract(split, field.getName(), field.getType()), batchSize) : parquetVectors[projectedNames.indexOf(field.getName())];
            }
            return new VectorizedColumnBatch(vectors);
        };
        return new ParquetColumnarRowInputFormat<FileSourceSplit>(hadoopConfig, projectedRowType, producedTypeInfo, factory, batchSize, isUtcTimestamp, isCaseSensitive);
    }

    private static class ColumnarRowReaderBatch
    extends ParquetVectorizedInputFormat.ParquetReaderBatch<RowData> {
        private final ColumnarRowIterator result;

        private ColumnarRowReaderBatch(WritableColumnVector[] writableVectors, VectorizedColumnBatch columnarBatch, Pool.Recycler<ParquetVectorizedInputFormat.ParquetReaderBatch<RowData>> recycler) {
            super(writableVectors, columnarBatch, recycler);
            this.result = new ColumnarRowIterator(new ColumnarRowData(columnarBatch), this::recycle);
        }

        @Override
        public BulkFormat.RecordIterator<RowData> convertAndGetIterator(long rowsReturned) {
            this.result.set(this.columnarBatch.getNumRows(), rowsReturned);
            return this.result;
        }
    }
}

