/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.io.airlift.compress.lz4;

import java.nio.ByteBuffer;
import org.apache.flink.table.store.shaded.io.airlift.compress.Decompressor;
import org.apache.flink.table.store.shaded.io.airlift.compress.MalformedInputException;
import org.apache.flink.table.store.shaded.io.airlift.compress.lz4.Lz4RawDecompressor;
import org.apache.flink.table.store.shaded.io.airlift.compress.lz4.UnsafeUtil;
import sun.misc.Unsafe;

public class Lz4Decompressor
implements Decompressor {
    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return Lz4RawDecompressor.decompress(input, inputAddress, inputLimit, output, outputAddress, outputLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(ByteBuffer input, ByteBuffer output) throws MalformedInputException {
        long outputLimit;
        long outputAddress;
        byte[] outputBase;
        long inputLimit;
        long inputAddress;
        byte[] inputBase;
        if (input.isDirect()) {
            inputBase = null;
            long address = UnsafeUtil.getAddress(input);
            inputAddress = address + (long)input.position();
            inputLimit = address + (long)input.limit();
        } else if (input.hasArray()) {
            inputBase = input.array();
            inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + input.arrayOffset() + input.position();
            inputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + input.arrayOffset() + input.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + input.getClass().getName());
        }
        if (output.isDirect()) {
            outputBase = null;
            long address = UnsafeUtil.getAddress(output);
            outputAddress = address + (long)output.position();
            outputLimit = address + (long)output.limit();
        } else if (output.hasArray()) {
            outputBase = output.array();
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.position();
            outputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + output.getClass().getName());
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = output;
            synchronized (byteBuffer2) {
                int written = Lz4RawDecompressor.decompress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit);
                output.position(output.position() + written);
            }
        }
    }
}

