/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.predicate;

import java.util.List;
import java.util.Optional;
import org.apache.flink.table.store.file.predicate.CompareUtils;
import org.apache.flink.table.store.file.predicate.FieldRef;
import org.apache.flink.table.store.file.predicate.FunctionVisitor;
import org.apache.flink.table.store.file.predicate.LeafFunction;
import org.apache.flink.table.store.file.predicate.NotEqual;
import org.apache.flink.table.store.file.predicate.NullFalseLeafBinaryFunction;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.types.logical.LogicalType;

public class Equal
extends NullFalseLeafBinaryFunction {
    public static final Equal INSTANCE = new Equal();

    private Equal() {
    }

    @Override
    public boolean test(LogicalType type, Object field, Object literal) {
        return CompareUtils.compareLiteral(type, literal, field) == 0;
    }

    @Override
    public boolean test(LogicalType type, long rowCount, FieldStats fieldStats, Object literal) {
        return CompareUtils.compareLiteral(type, literal, fieldStats.minValue()) >= 0 && CompareUtils.compareLiteral(type, literal, fieldStats.maxValue()) <= 0;
    }

    @Override
    public Optional<LeafFunction> negate() {
        return Optional.of(NotEqual.INSTANCE);
    }

    @Override
    public <T> T visit(FunctionVisitor<T> visitor, FieldRef fieldRef, List<Object> literals) {
        return visitor.visitEqual(fieldRef, literals.get(0));
    }
}

