/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestFile;
import org.apache.flink.table.store.file.manifest.ManifestFileMeta;
import org.apache.flink.table.store.file.manifest.ManifestList;
import org.apache.flink.table.store.file.operation.FileStoreExpire;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreExpireImpl
implements FileStoreExpire {
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreExpireImpl.class);
    private final int numRetainedMin;
    private final int numRetainedMax;
    private final long millisRetained;
    private final FileStorePathFactory pathFactory;
    private final SnapshotManager snapshotManager;
    private final ManifestFile manifestFile;
    private final ManifestList manifestList;
    private Lock lock;

    public FileStoreExpireImpl(int numRetainedMin, int numRetainedMax, long millisRetained, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory) {
        this.numRetainedMin = numRetainedMin;
        this.numRetainedMax = numRetainedMax;
        this.millisRetained = millisRetained;
        this.pathFactory = pathFactory;
        this.snapshotManager = snapshotManager;
        this.manifestFile = manifestFileFactory.create();
        this.manifestList = manifestListFactory.create();
    }

    @Override
    public FileStoreExpire withLock(Lock lock) {
        this.lock = lock;
        return this;
    }

    @Override
    public void expire() {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return;
        }
        long currentMillis = System.currentTimeMillis();
        Long earliest = this.snapshotManager.earliestSnapshotId();
        if (earliest == null) {
            return;
        }
        for (long id = Math.max(latestSnapshotId - (long)this.numRetainedMax + 1L, earliest); id <= latestSnapshotId - (long)this.numRetainedMin; ++id) {
            if (!this.snapshotManager.snapshotExists(id) || currentMillis - this.snapshotManager.snapshot(id).timeMillis() > this.millisRetained) continue;
            this.expireUntil(earliest, id);
            return;
        }
        this.expireUntil(earliest, latestSnapshotId - (long)this.numRetainedMin + 1L);
    }

    private void expireUntil(long earliestId, long endExclusiveId) {
        Snapshot snapshot;
        long id;
        if (endExclusiveId <= earliestId) {
            if (this.snapshotManager.readHint("EARLIEST") == null) {
                this.writeEarliestHint(endExclusiveId);
            }
            return;
        }
        long beginInclusiveId = earliestId;
        for (id = endExclusiveId - 1L; id >= earliestId; --id) {
            if (this.snapshotManager.snapshotExists(id)) continue;
            beginInclusiveId = id + 1L;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Snapshot expire range is [" + beginInclusiveId + ", " + endExclusiveId + ")");
        }
        for (id = beginInclusiveId + 1L; id <= endExclusiveId; ++id) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete merge tree files not used by snapshot #" + id);
            }
            snapshot = this.snapshotManager.snapshot(id);
            this.expireMergeTreeFiles(snapshot.deltaManifestList());
        }
        for (id = beginInclusiveId; id < endExclusiveId; ++id) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete changelog files from snapshot #" + id);
            }
            if ((snapshot = this.snapshotManager.snapshot(id)).changelogManifestList() == null) continue;
            this.expireChangelogFiles(snapshot.changelogManifestList());
        }
        Snapshot exclusiveSnapshot = this.snapshotManager.snapshot(endExclusiveId);
        HashSet<ManifestFileMeta> manifestsInUse = new HashSet<ManifestFileMeta>(exclusiveSnapshot.readAllDataManifests(this.manifestList));
        HashSet<ManifestFileMeta> deletedManifests = new HashSet<ManifestFileMeta>();
        for (long id2 = beginInclusiveId; id2 < endExclusiveId; ++id2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete manifests in snapshot #" + id2);
            }
            Snapshot toExpire = this.snapshotManager.snapshot(id2);
            for (ManifestFileMeta manifest : toExpire.readAllDataManifests(this.manifestList)) {
                if (manifestsInUse.contains(manifest) || deletedManifests.contains(manifest)) continue;
                this.manifestFile.delete(manifest.fileName());
                deletedManifests.add(manifest);
            }
            if (toExpire.changelogManifestList() != null) {
                for (ManifestFileMeta manifest : this.manifestList.read(toExpire.changelogManifestList())) {
                    this.manifestFile.delete(manifest.fileName());
                }
            }
            this.manifestList.delete(toExpire.baseManifestList());
            this.manifestList.delete(toExpire.deltaManifestList());
            if (toExpire.changelogManifestList() != null) {
                this.manifestList.delete(toExpire.changelogManifestList());
            }
            FileUtils.deleteOrWarn(this.snapshotManager.snapshotPath(id2));
        }
        this.writeEarliestHint(endExclusiveId);
    }

    private void expireMergeTreeFiles(String manifestListName) {
        this.expireMergeTreeFiles(this.getManifestEntriesFromManifestList(manifestListName));
    }

    @VisibleForTesting
    void expireMergeTreeFiles(Iterable<ManifestEntry> dataFileLog) {
        HashMap<Path, List> dataFileToDelete = new HashMap<Path, List>();
        block4: for (ManifestEntry entry : dataFileLog) {
            Path bucketPath = this.pathFactory.bucketPath(entry.partition(), entry.bucket());
            Path dataFilePath = new Path(bucketPath, entry.file().fileName());
            switch (entry.kind()) {
                case ADD: {
                    dataFileToDelete.remove(dataFilePath);
                    continue block4;
                }
                case DELETE: {
                    ArrayList<Path> extraFiles2 = new ArrayList<Path>(entry.file().extraFiles().size());
                    for (String file : entry.file().extraFiles()) {
                        extraFiles2.add(new Path(bucketPath, file));
                    }
                    dataFileToDelete.put(dataFilePath, extraFiles2);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown value kind " + entry.kind().name());
        }
        dataFileToDelete.forEach((path, extraFiles) -> {
            FileUtils.deleteOrWarn(path);
            extraFiles.forEach(FileUtils::deleteOrWarn);
        });
    }

    private void expireChangelogFiles(String manifestListName) {
        for (ManifestEntry changelogEntry : this.getManifestEntriesFromManifestList(manifestListName)) {
            FileUtils.deleteOrWarn(new Path(this.pathFactory.bucketPath(changelogEntry.partition(), changelogEntry.bucket()), changelogEntry.file().fileName()));
        }
    }

    private Iterable<ManifestEntry> getManifestEntriesFromManifestList(String manifestListName) {
        List<String> manifestFiles = this.manifestList.read(manifestListName).stream().map(ManifestFileMeta::fileName).collect(Collectors.toList());
        return this.manifestFile.readManifestFiles(manifestFiles);
    }

    private void writeEarliestHint(long earliest) {
        Callable<Void> callable = () -> {
            this.snapshotManager.commitEarliestHint(earliest);
            return null;
        };
        try {
            if (this.lock != null) {
                this.lock.runWithLock(callable);
            } else {
                callable.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

