/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunctionWrapper;
import org.apache.flink.table.store.file.mergetree.compact.ValueCountMergeFunction;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class FullChangelogMergeFunctionWrapper
implements MergeFunctionWrapper<Result> {
    private final MergeFunction<KeyValue> mergeFunction;
    private final int maxLevel;
    private transient KeyValue topLevelKv;
    private transient KeyValue initialKv;
    private transient boolean isInitialized;
    private transient Result reusedResult;
    private transient KeyValue reusedBefore;
    private transient KeyValue reusedAfter;

    public FullChangelogMergeFunctionWrapper(MergeFunction<KeyValue> mergeFunction, int maxLevel) {
        Preconditions.checkArgument(!(mergeFunction instanceof ValueCountMergeFunction), "Value count merge function does not need to produce changelog from full compaction. Please set changelog producer to 'input'.");
        this.mergeFunction = mergeFunction;
        this.maxLevel = maxLevel;
    }

    @Override
    public void reset() {
        this.mergeFunction.reset();
        this.topLevelKv = null;
        this.initialKv = null;
        this.isInitialized = false;
    }

    @Override
    public void add(KeyValue kv) {
        if (this.maxLevel == kv.level()) {
            Preconditions.checkState(this.topLevelKv == null, "Top level key-value already exists! This is unexpected.");
            this.topLevelKv = kv;
        }
        if (this.initialKv == null) {
            this.initialKv = kv;
        } else {
            if (!this.isInitialized) {
                this.merge(this.initialKv);
                this.isInitialized = true;
            }
            this.merge(kv);
        }
    }

    private void merge(KeyValue kv) {
        this.mergeFunction.add(kv);
    }

    @Override
    public Result getResult() {
        if (this.reusedResult == null) {
            this.reusedResult = new Result();
            this.reusedBefore = new KeyValue();
            this.reusedAfter = new KeyValue();
        }
        if (this.isInitialized) {
            KeyValue merged = this.mergeFunction.getResult();
            if (this.topLevelKv == null) {
                if (merged != null && this.isAdd(merged)) {
                    this.reusedResult.setChangelog(null, this.replace(this.reusedAfter, RowKind.INSERT, merged));
                } else {
                    this.reusedResult.setChangelog(null, null);
                }
            } else if (merged != null && this.isAdd(merged)) {
                this.reusedResult.setChangelog(this.replace(this.reusedBefore, RowKind.UPDATE_BEFORE, this.topLevelKv), this.replace(this.reusedAfter, RowKind.UPDATE_AFTER, merged));
            } else {
                this.reusedResult.setChangelog(this.replace(this.reusedBefore, RowKind.DELETE, this.topLevelKv), null);
            }
            return this.reusedResult.setResult(merged);
        }
        if (this.topLevelKv == null && this.isAdd(this.initialKv)) {
            this.reusedResult.setChangelog(null, this.replace(this.reusedAfter, RowKind.INSERT, this.initialKv));
        } else {
            this.reusedResult.setChangelog(null, null);
        }
        return this.reusedResult.setResult(this.initialKv);
    }

    private KeyValue replace(KeyValue reused, RowKind valueKind, KeyValue from) {
        return reused.replace(from.key(), from.sequenceNumber(), valueKind, from.value());
    }

    private boolean isAdd(KeyValue kv) {
        return kv.valueKind() == RowKind.INSERT || kv.valueKind() == RowKind.UPDATE_AFTER;
    }

    public static class Result {
        @Nullable
        private KeyValue before;
        @Nullable
        private KeyValue after;
        @Nullable
        private KeyValue result;

        private Result() {
        }

        private void setChangelog(@Nullable KeyValue before, @Nullable KeyValue after) {
            this.before = before;
            this.after = after;
        }

        private Result setResult(@Nullable KeyValue result) {
            this.result = result != null && result.valueKind() != RowKind.DELETE ? result : null;
            return this;
        }

        @Nullable
        public KeyValue before() {
            return this.before;
        }

        @Nullable
        public KeyValue after() {
            return this.after;
        }

        @Nullable
        public KeyValue result() {
            return this.result;
        }
    }
}

