/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.store.file.schema.AtomicDataType;
import org.apache.flink.table.store.file.schema.DataField;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class KeyValue {
    public static final long UNKNOWN_SEQUENCE = -1L;
    public static final int UNKNOWN_LEVEL = -1;
    private RowData key;
    private long sequenceNumber;
    private RowKind valueKind;
    private RowData value;
    private int level;

    public KeyValue replace(RowData key, RowKind valueKind, RowData value) {
        return this.replace(key, -1L, valueKind, value);
    }

    public KeyValue replace(RowData key, long sequenceNumber, RowKind valueKind, RowData value) {
        this.key = key;
        this.sequenceNumber = sequenceNumber;
        this.valueKind = valueKind;
        this.value = value;
        this.level = -1;
        return this;
    }

    public KeyValue replaceKey(RowData key) {
        this.key = key;
        return this;
    }

    public RowData key() {
        return this.key;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public RowKind valueKind() {
        return this.valueKind;
    }

    public RowData value() {
        return this.value;
    }

    public int level() {
        return this.level;
    }

    public KeyValue setLevel(int level) {
        this.level = level;
        return this;
    }

    public static RowType schema(RowType keyType, RowType valueType) {
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>(keyType.getFields());
        fields.add(new RowType.RowField("_SEQUENCE_NUMBER", new BigIntType(false)));
        fields.add(new RowType.RowField("_VALUE_KIND", new TinyIntType(false)));
        fields.addAll(valueType.getFields());
        return new RowType(fields);
    }

    public static List<DataField> createKeyValueFields(List<DataField> keyFields, List<DataField> valueFields, int maxKeyId) {
        Preconditions.checkState(maxKeyId >= keyFields.stream().mapToInt(DataField::id).max().orElse(0));
        ArrayList<DataField> fields = new ArrayList<DataField>(keyFields.size() + valueFields.size() + 2);
        fields.addAll(keyFields);
        fields.add(new DataField(maxKeyId + 1, "_SEQUENCE_NUMBER", new AtomicDataType(new BigIntType(false))));
        fields.add(new DataField(maxKeyId + 2, "_VALUE_KIND", new AtomicDataType(new TinyIntType(false))));
        for (DataField valueField : valueFields) {
            DataField newValueField = new DataField(valueField.id() + maxKeyId + 3, valueField.name(), valueField.type(), valueField.description());
            fields.add(newValueField);
        }
        return fields;
    }

    public static int[][] project(int[][] keyProjection, int[][] valueProjection, int numKeyFields) {
        int i;
        int[][] projection = new int[keyProjection.length + 2 + valueProjection.length][];
        for (i = 0; i < keyProjection.length; ++i) {
            projection[i] = new int[keyProjection[i].length];
            System.arraycopy(keyProjection[i], 0, projection[i], 0, keyProjection[i].length);
        }
        projection[keyProjection.length] = new int[]{numKeyFields};
        projection[keyProjection.length + 1] = new int[]{numKeyFields + 1};
        for (i = 0; i < valueProjection.length; ++i) {
            int idx = keyProjection.length + 2 + i;
            projection[idx] = new int[valueProjection[i].length];
            System.arraycopy(valueProjection[i], 0, projection[idx], 0, valueProjection[i].length);
            int[] nArray = projection[idx];
            nArray[0] = nArray[0] + (numKeyFields + 2);
        }
        return projection;
    }

    @VisibleForTesting
    public KeyValue copy(RowDataSerializer keySerializer, RowDataSerializer valueSerializer) {
        return new KeyValue().replace(keySerializer.copy(this.key), this.sequenceNumber, this.valueKind, valueSerializer.copy(this.value)).setLevel(this.level);
    }

    @VisibleForTesting
    public String toString(RowType keyType, RowType valueType) {
        String keyString = KeyValue.rowDataToString(this.key, keyType);
        String valueString = KeyValue.rowDataToString(this.value, valueType);
        return String.format("{kind: %s, seq: %d, key: (%s), value: (%s), level: %d}", this.valueKind.name(), this.sequenceNumber, keyString, valueString, this.level);
    }

    public static String rowDataToString(RowData row, RowType type) {
        return IntStream.range(0, type.getFieldCount()).mapToObj(i -> String.valueOf(RowDataUtils.createNullCheckingFieldGetter(type.getTypeAt(i), i).getFieldOrNull(row))).collect(Collectors.joining(", "));
    }
}

