/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections;

import org.apache.flink.util.Preconditions;

public abstract class OptimizableHashSet {
    public static final int DEFAULT_INITIAL_SIZE = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DENSE_THRESHOLD = 8192;
    protected final float f;
    protected int mask;
    protected int n;
    protected int maxFill;
    protected boolean containsNull;
    protected boolean containsZero;
    protected int size;
    protected boolean isDense = false;
    protected boolean[] used;

    public OptimizableHashSet(int expected, float f) {
        Preconditions.checkArgument(f > 0.0f && f <= 1.0f);
        Preconditions.checkArgument(expected >= 0);
        this.f = f;
        this.n = OptimizableHashSet.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = OptimizableHashSet.maxFill(this.n, f);
    }

    public void addNull() {
        this.containsNull = true;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    protected int realSize() {
        return this.containsZero ? this.size - 1 : this.size;
    }

    public abstract void optimize();

    public static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    public static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    public static int arraySize(int expected, float f) {
        long s = Math.max(2L, OptimizableHashSet.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }
}

