/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink;

import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;

public class SinkOperator
extends AbstractUdfStreamOperator<Object, SinkFunction<RowData>>
implements OneInputStreamOperator<RowData, Object> {
    private static final long serialVersionUID = 1L;
    private final int rowtimeFieldIndex;
    private transient SimpleContext sinkContext;
    private long currentWatermark = Long.MIN_VALUE;

    public SinkOperator(SinkFunction<RowData> sinkFunction, int rowtimeFieldIndex) {
        super(sinkFunction);
        this.rowtimeFieldIndex = rowtimeFieldIndex;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.sinkContext = new SimpleContext(this.getProcessingTimeService());
    }

    @Override
    public void processElement(StreamRecord<RowData> element) throws Exception {
        this.sinkContext.element = element;
        ((SinkFunction)this.userFunction).invoke(element.getValue(), this.sinkContext);
    }

    @Override
    protected void reportOrForwardLatencyMarker(LatencyMarker marker) {
        this.latencyStats.reportLatency(marker);
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    private class SimpleContext
    implements SinkFunction.Context {
        private StreamRecord<RowData> element;
        private final ProcessingTimeService processingTimeService;

        public SimpleContext(ProcessingTimeService processingTimeService) {
            this.processingTimeService = processingTimeService;
        }

        @Override
        public long currentProcessingTime() {
            return this.processingTimeService.getCurrentProcessingTime();
        }

        @Override
        public long currentWatermark() {
            return SinkOperator.this.currentWatermark;
        }

        @Override
        public Long timestamp() {
            if (SinkOperator.this.rowtimeFieldIndex >= 0) {
                TimestampData timestamp = this.element.getValue().getTimestamp(SinkOperator.this.rowtimeFieldIndex, 3);
                if (timestamp != null) {
                    return timestamp.getMillisecond();
                }
                return null;
            }
            return null;
        }
    }
}

