/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import java.util.Collection;
import java.util.function.Predicate;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.streaming.api.functions.async.AsyncRetryPredicate;
import org.apache.flink.streaming.api.functions.async.AsyncRetryStrategy;
import org.apache.flink.streaming.util.retryable.AsyncRetryStrategies;
import org.apache.flink.table.data.RowData;

public class ResultRetryStrategy
implements AsyncRetryStrategy<RowData> {
    public static final ResultRetryStrategy NO_RETRY_STRATEGY = new ResultRetryStrategy(AsyncRetryStrategies.NO_RETRY_STRATEGY);
    private AsyncRetryStrategy retryStrategy;

    @VisibleForTesting
    public ResultRetryStrategy(AsyncRetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public static ResultRetryStrategy fixedDelayRetry(int maxAttempts, long backoffTimeMillis, Predicate<Collection<RowData>> resultPredicate) {
        return new ResultRetryStrategy(new AsyncRetryStrategies.FixedDelayRetryStrategyBuilder(maxAttempts, backoffTimeMillis).ifResult(resultPredicate).build());
    }

    @Override
    public boolean canRetry(int currentAttempts) {
        return this.retryStrategy.canRetry(currentAttempts);
    }

    @Override
    public long getBackoffTimeMillis(int currentAttempts) {
        return this.retryStrategy.getBackoffTimeMillis(currentAttempts);
    }

    @Override
    public AsyncRetryPredicate<RowData> getRetryPredicate() {
        return this.retryStrategy.getRetryPredicate();
    }
}

