/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.join.NullAwareJoinHelper;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.util.MutableObjectIterator;

public abstract class SortMergeJoinIterator
implements Closeable {
    private final Projection<RowData, BinaryRowData> probeProjection;
    private final Projection<RowData, BinaryRowData> bufferedProjection;
    protected final RecordComparator keyComparator;
    private final MutableObjectIterator<RowData> probeIterator;
    private final MutableObjectIterator<BinaryRowData> bufferedIterator;
    private RowData probeRow;
    protected BinaryRowData probeKey;
    protected BinaryRowData bufferedRow;
    protected BinaryRowData bufferedKey;
    protected BinaryRowData matchKey;
    protected ResettableExternalBuffer matchBuffer;
    private final int[] nullFilterKeys;
    private final boolean nullSafe;
    private final boolean filterAllNulls;

    public SortMergeJoinIterator(BinaryRowDataSerializer probeSerializer, BinaryRowDataSerializer bufferedSerializer, Projection<RowData, BinaryRowData> probeProjection, Projection<RowData, BinaryRowData> bufferedProjection, RecordComparator keyComparator, MutableObjectIterator<RowData> probeIterator, MutableObjectIterator<BinaryRowData> bufferedIterator, ResettableExternalBuffer buffer, boolean[] filterNulls) throws IOException {
        this.probeProjection = probeProjection;
        this.bufferedProjection = bufferedProjection;
        this.keyComparator = keyComparator;
        this.probeIterator = probeIterator;
        this.bufferedIterator = bufferedIterator;
        this.probeRow = probeSerializer.createInstance();
        this.bufferedRow = bufferedSerializer.createInstance();
        this.matchBuffer = buffer;
        this.nullFilterKeys = NullAwareJoinHelper.getNullFilterKeys(filterNulls);
        this.nullSafe = this.nullFilterKeys.length == 0;
        this.filterAllNulls = this.nullFilterKeys.length == filterNulls.length;
        this.advanceNextSuitableBufferedRow();
    }

    protected boolean advanceNextSuitableProbeRow() throws IOException {
        while (this.nextProbe() && this.shouldFilter(this.probeKey)) {
        }
        return this.probeRow != null;
    }

    protected boolean advanceNextSuitableBufferedRow() throws IOException {
        while (this.nextBuffered() && this.shouldFilter(this.bufferedKey)) {
        }
        return this.bufferedRow != null;
    }

    private boolean shouldFilter(BinaryRowData key) {
        return NullAwareJoinHelper.shouldFilter(this.nullSafe, this.filterAllNulls, this.nullFilterKeys, key);
    }

    protected boolean nextProbe() throws IOException {
        this.probeRow = this.probeIterator.next(this.probeRow);
        if (this.probeRow != null) {
            this.probeKey = this.probeProjection.apply(this.probeRow);
            return true;
        }
        this.probeRow = null;
        this.probeKey = null;
        return false;
    }

    private boolean nextBuffered() throws IOException {
        this.bufferedRow = this.bufferedIterator.next(this.bufferedRow);
        if (this.bufferedRow != null) {
            this.bufferedKey = this.bufferedProjection.apply(this.bufferedRow);
            return true;
        }
        this.bufferedRow = null;
        this.bufferedKey = null;
        return false;
    }

    protected void bufferMatchingRows() throws IOException {
        this.matchKey = this.probeKey.copy();
        this.matchBuffer.reset();
        do {
            this.matchBuffer.add(this.bufferedRow);
        } while (this.advanceNextSuitableBufferedRow() && this.keyComparator.compare(this.probeKey, this.bufferedKey) == 0);
        this.matchBuffer.complete();
    }

    public RowData getProbeRow() {
        return this.probeRow;
    }

    public BinaryRowData getMatchKey() {
        return this.matchKey;
    }

    public ResettableExternalBuffer getMatchBuffer() {
        return this.matchBuffer;
    }

    @Override
    public void close() {
        this.matchBuffer.close();
    }
}

