/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.combines;

import java.util.Iterator;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.UnsupportedStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.window.combines.RecordsCombiner;
import org.apache.flink.table.runtime.util.WindowKey;
import org.apache.flink.util.Collector;

public class LocalAggCombiner
implements RecordsCombiner {
    private final NamespaceAggsHandleFunction<Long> aggregator;
    private final Collector<RowData> collector;
    private final JoinedRowData resultRow = new JoinedRowData();
    private final JoinedRowData accWindowRow = new JoinedRowData();
    private final GenericRowData windowRow = new GenericRowData(1);

    public LocalAggCombiner(NamespaceAggsHandleFunction<Long> aggregator, Collector<RowData> collector) {
        this.aggregator = aggregator;
        this.collector = collector;
    }

    @Override
    public void combine(WindowKey windowKey, Iterator<RowData> records) throws Exception {
        RowData key = windowKey.getKey();
        Long window = windowKey.getWindow();
        RowData acc = this.aggregator.createAccumulators();
        this.aggregator.setAccumulators(window, acc);
        while (records.hasNext()) {
            RowData record = records.next();
            if (RowDataUtil.isAccumulateMsg(record)) {
                this.aggregator.accumulate(record);
                continue;
            }
            this.aggregator.retract(record);
        }
        acc = this.aggregator.getAccumulators();
        this.output(key, window, acc);
    }

    @Override
    public void close() throws Exception {
        this.aggregator.close();
    }

    private void output(RowData key, Long window, RowData acc) {
        this.windowRow.setField(0, window);
        this.accWindowRow.replace(acc, this.windowRow);
        this.resultRow.replace(key, this.accWindowRow);
        this.collector.collect(this.resultRow);
    }

    public static final class Factory
    implements RecordsCombiner.LocalFactory {
        private static final long serialVersionUID = 1L;
        private final GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler;

        public Factory(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler) {
            this.genAggsHandler = genAggsHandler;
        }

        @Override
        public RecordsCombiner createRecordsCombiner(RuntimeContext runtimeContext, Collector<RowData> collector) throws Exception {
            NamespaceAggsHandleFunction aggregator = (NamespaceAggsHandleFunction)this.genAggsHandler.newInstance(runtimeContext.getUserCodeClassLoader());
            aggregator.open(new UnsupportedStateDataViewStore(runtimeContext));
            return new LocalAggCombiner(aggregator, collector);
        }
    }
}

