/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.combines;

import java.time.ZoneId;
import java.util.Iterator;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.dataview.PerWindowStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.window.combines.RecordsCombiner;
import org.apache.flink.table.runtime.operators.window.slicing.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.state.StateKeyContext;
import org.apache.flink.table.runtime.operators.window.state.WindowState;
import org.apache.flink.table.runtime.operators.window.state.WindowValueState;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.runtime.util.WindowKey;

public class AggCombiner
implements RecordsCombiner {
    private final WindowTimerService<Long> timerService;
    private final StateKeyContext keyContext;
    private final WindowValueState<Long> accState;
    private final NamespaceAggsHandleFunction<Long> aggregator;
    private final boolean isEventTime;

    public AggCombiner(WindowTimerService<Long> timerService, StateKeyContext keyContext, WindowValueState<Long> accState, NamespaceAggsHandleFunction<Long> aggregator, boolean isEventTime) {
        this.timerService = timerService;
        this.keyContext = keyContext;
        this.accState = accState;
        this.aggregator = aggregator;
        this.isEventTime = isEventTime;
    }

    @Override
    public void combine(WindowKey windowKey, Iterator<RowData> records) throws Exception {
        this.keyContext.setCurrentKey(windowKey.getKey());
        Long window = windowKey.getWindow();
        RowData acc = this.accState.value(window);
        if (acc == null) {
            acc = this.aggregator.createAccumulators();
        }
        this.aggregator.setAccumulators(window, acc);
        while (records.hasNext()) {
            RowData record = records.next();
            if (RowDataUtil.isAccumulateMsg(record)) {
                this.aggregator.accumulate(record);
                continue;
            }
            this.aggregator.retract(record);
        }
        acc = this.aggregator.getAccumulators();
        this.accState.update(window, acc);
        if (this.isEventTime) {
            long currentWatermark = this.timerService.currentWatermark();
            ZoneId shiftTimeZone = this.timerService.getShiftTimeZone();
            if (!TimeWindowUtil.isWindowFired(window, currentWatermark, shiftTimeZone)) {
                this.timerService.registerEventTimeWindowTimer(window);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.aggregator.close();
    }

    public static final class Factory
    implements RecordsCombiner.Factory {
        private static final long serialVersionUID = 1L;
        private final GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler;

        public Factory(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler) {
            this.genAggsHandler = genAggsHandler;
        }

        @Override
        public RecordsCombiner createRecordsCombiner(RuntimeContext runtimeContext, WindowTimerService<Long> timerService, KeyedStateBackend<RowData> stateBackend, WindowState<Long> windowState, boolean isEventTime) throws Exception {
            NamespaceAggsHandleFunction aggregator = (NamespaceAggsHandleFunction)this.genAggsHandler.newInstance(runtimeContext.getUserCodeClassLoader());
            aggregator.open(new PerWindowStateDataViewStore(stateBackend, LongSerializer.INSTANCE, runtimeContext));
            WindowValueState windowValueState = (WindowValueState)windowState;
            return new AggCombiner(timerService, stateBackend::setCurrentKey, windowValueState, aggregator, isEventTime);
        }
    }
}

