/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.plan.stats.ColumnStats;

@PublicEvolving
public final class TableStats {
    public static final TableStats UNKNOWN = new TableStats(-1L, new HashMap<String, ColumnStats>());
    private final long rowCount;
    private final Map<String, ColumnStats> colStats;

    public TableStats(long rowCount) {
        this(rowCount, new HashMap<String, ColumnStats>());
    }

    public TableStats(long rowCount, Map<String, ColumnStats> colStats) {
        this.rowCount = rowCount;
        this.colStats = colStats;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public Map<String, ColumnStats> getColumnStats() {
        return this.colStats;
    }

    public TableStats copy() {
        TableStats copy = new TableStats(this.rowCount);
        for (Map.Entry<String, ColumnStats> entry : this.colStats.entrySet()) {
            copy.colStats.put(entry.getKey(), entry.getValue().copy());
        }
        return copy;
    }

    public TableStats merge(TableStats other, @Nullable Set<String> partitionKeys) {
        if (this.rowCount < 0L || other.rowCount < 0L) {
            return UNKNOWN;
        }
        long rowCount = this.rowCount >= 0L && other.rowCount >= 0L ? this.rowCount + other.rowCount : TableStats.UNKNOWN.rowCount;
        return new TableStats(rowCount, this.mergeColumnStates(other, partitionKeys));
    }

    private Map<String, ColumnStats> mergeColumnStates(TableStats other, @Nullable Set<String> partitionKeys) {
        HashMap<String, ColumnStats> colStats = new HashMap<String, ColumnStats>();
        for (Map.Entry<String, ColumnStats> entry : this.colStats.entrySet()) {
            String col = entry.getKey();
            ColumnStats stats = entry.getValue();
            ColumnStats otherStats = other.colStats.get(col);
            if (otherStats == null) continue;
            if (partitionKeys != null) {
                colStats.put(col, stats.merge(otherStats, partitionKeys.contains(col)));
                continue;
            }
            colStats.put(col, stats.merge(otherStats, false));
        }
        return colStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableStats that = (TableStats)o;
        return this.rowCount == that.rowCount && Objects.equals(this.colStats, that.colStats);
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.colStats);
    }

    public String toString() {
        return "TableStats{rowCount=" + this.rowCount + ", colStats=" + this.colStats + '}';
    }
}

