/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.stream.Collectors;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterViewOperation;

public class AlterViewPropertiesOperation
extends AlterViewOperation {
    private final CatalogView catalogView;

    public AlterViewPropertiesOperation(ObjectIdentifier viewIdentifier, CatalogView catalogView) {
        super(viewIdentifier);
        this.catalogView = catalogView;
    }

    public CatalogView getCatalogView() {
        return this.catalogView;
    }

    @Override
    public String asSummaryString() {
        String description = this.catalogView.getOptions().entrySet().stream().map(entry -> OperationUtils.formatParameter((String)entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        return String.format("ALTER VIEW %s SET (%s)", this.viewIdentifier.asSummaryString(), description);
    }
}

