/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.ModifyOperationVisitor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;

@Internal
public final class ExternalModifyOperation
implements ModifyOperation {
    private final ContextResolvedTable contextResolvedTable;
    private final QueryOperation child;
    @Nullable
    private final ChangelogMode changelogMode;
    private final DataType physicalDataType;

    public ExternalModifyOperation(ContextResolvedTable contextResolvedTable, QueryOperation child, @Nullable ChangelogMode changelogMode, DataType physicalDataType) {
        this.contextResolvedTable = contextResolvedTable;
        this.child = child;
        this.changelogMode = changelogMode;
        this.physicalDataType = physicalDataType;
    }

    public ContextResolvedTable getContextResolvedTable() {
        return this.contextResolvedTable;
    }

    @Override
    public QueryOperation getChild() {
        return this.child;
    }

    public DataType getPhysicalDataType() {
        return this.physicalDataType;
    }

    public Optional<ChangelogMode> getChangelogMode() {
        return Optional.ofNullable(this.changelogMode);
    }

    @Override
    public <T> T accept(ModifyOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("identifier", this.getContextResolvedTable().getIdentifier().asSummaryString());
        args.put("changelogMode", this.changelogMode);
        args.put("type", this.physicalDataType);
        return OperationUtils.formatWithChildren("DataStreamOutput", args, Collections.singletonList(this.child), Operation::asSummaryString);
    }
}

