/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ResolvedFieldReference {
    private final String name;
    private final TypeInformation<?> resultType;
    private final int fieldIndex;

    public ResolvedFieldReference(String name, TypeInformation<?> resultType, int fieldIndex) {
        Preconditions.checkArgument(fieldIndex >= 0, "Index of field should be a positive number");
        this.name = Preconditions.checkNotNull(name, "Field name must not be null.");
        this.resultType = Preconditions.checkNotNull(resultType, "Field result type must not be null.");
        this.fieldIndex = fieldIndex;
    }

    public TypeInformation<?> resultType() {
        return this.resultType;
    }

    public String name() {
        return this.name;
    }

    public int fieldIndex() {
        return this.fieldIndex;
    }
}

