/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.columnar;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.TypedSetters;
import org.apache.flink.table.data.columnar.vector.BytesColumnVector;
import org.apache.flink.table.data.columnar.vector.VectorizedColumnBatch;
import org.apache.flink.types.RowKind;

@Internal
public final class ColumnarRowData
implements RowData,
TypedSetters {
    private RowKind rowKind = RowKind.INSERT;
    private VectorizedColumnBatch vectorizedColumnBatch;
    private int rowId;

    public ColumnarRowData() {
    }

    public ColumnarRowData(VectorizedColumnBatch vectorizedColumnBatch) {
        this(vectorizedColumnBatch, 0);
    }

    public ColumnarRowData(VectorizedColumnBatch vectorizedColumnBatch, int rowId) {
        this.vectorizedColumnBatch = vectorizedColumnBatch;
        this.rowId = rowId;
    }

    public void setVectorizedColumnBatch(VectorizedColumnBatch vectorizedColumnBatch) {
        this.vectorizedColumnBatch = vectorizedColumnBatch;
        this.rowId = 0;
    }

    public void setRowId(int rowId) {
        this.rowId = rowId;
    }

    @Override
    public RowKind getRowKind() {
        return this.rowKind;
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.rowKind = kind;
    }

    @Override
    public int getArity() {
        return this.vectorizedColumnBatch.getArity();
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.vectorizedColumnBatch.isNullAt(this.rowId, pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.vectorizedColumnBatch.getBoolean(this.rowId, pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.vectorizedColumnBatch.getByte(this.rowId, pos);
    }

    @Override
    public short getShort(int pos) {
        return this.vectorizedColumnBatch.getShort(this.rowId, pos);
    }

    @Override
    public int getInt(int pos) {
        return this.vectorizedColumnBatch.getInt(this.rowId, pos);
    }

    @Override
    public long getLong(int pos) {
        return this.vectorizedColumnBatch.getLong(this.rowId, pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.vectorizedColumnBatch.getFloat(this.rowId, pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.vectorizedColumnBatch.getDouble(this.rowId, pos);
    }

    @Override
    public StringData getString(int pos) {
        BytesColumnVector.Bytes byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, pos);
        return StringData.fromBytes(byteArray.data, byteArray.offset, byteArray.len);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return this.vectorizedColumnBatch.getDecimal(this.rowId, pos, precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return this.vectorizedColumnBatch.getTimestamp(this.rowId, pos, precision);
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        throw new UnsupportedOperationException("RawValueData is not supported.");
    }

    @Override
    public byte[] getBinary(int pos) {
        BytesColumnVector.Bytes byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, pos);
        if (byteArray.len == byteArray.data.length) {
            return byteArray.data;
        }
        byte[] ret = new byte[byteArray.len];
        System.arraycopy(byteArray.data, byteArray.offset, ret, 0, byteArray.len);
        return ret;
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return this.vectorizedColumnBatch.getRow(this.rowId, pos);
    }

    @Override
    public ArrayData getArray(int pos) {
        return this.vectorizedColumnBatch.getArray(this.rowId, pos);
    }

    @Override
    public MapData getMap(int pos) {
        return this.vectorizedColumnBatch.getMap(this.rowId, pos);
    }

    @Override
    public void setNullAt(int pos) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setByte(int pos, byte value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setShort(int pos, short value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setInt(int pos, int value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setLong(int pos, long value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setFloat(int pos, float value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDouble(int pos, double value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDecimal(int pos, DecimalData value, int precision) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setTimestamp(int pos, TimestampData value, int precision) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("ColumnarRowData do not support equals, please compare fields one by one!");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ColumnarRowData do not support hashCode, please hash fields one by one!");
    }
}

