/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.binary;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinarySection;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@Internal
public final class BinaryMapData
extends BinarySection
implements MapData {
    private final BinaryArrayData keys = new BinaryArrayData();
    private final BinaryArrayData values = new BinaryArrayData();

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public void pointTo(MemorySegment[] segments, int offset, int sizeInBytes) {
        int keyArrayBytes = BinarySegmentUtils.getInt(segments, offset);
        assert (keyArrayBytes >= 0) : "keyArraySize (" + keyArrayBytes + ") should >= 0";
        int valueArrayBytes = sizeInBytes - keyArrayBytes - 4;
        assert (valueArrayBytes >= 0) : "valueArraySize (" + valueArrayBytes + ") should >= 0";
        this.keys.pointTo(segments, offset + 4, keyArrayBytes);
        this.values.pointTo(segments, offset + 4 + keyArrayBytes, valueArrayBytes);
        assert (this.keys.size() == this.values.size());
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public BinaryArrayData keyArray() {
        return this.keys;
    }

    @Override
    public BinaryArrayData valueArray() {
        return this.values;
    }

    public Map<?, ?> toJavaMap(LogicalType keyType, LogicalType valueType) {
        T[] keyArray = this.keys.toObjectArray(keyType);
        T[] valueArray = this.values.toObjectArray(valueType);
        HashMap map = new HashMap();
        for (int i = 0; i < keyArray.length; ++i) {
            map.put(keyArray[i], valueArray[i]);
        }
        return map;
    }

    public BinaryMapData copy() {
        return this.copy(new BinaryMapData());
    }

    public BinaryMapData copy(BinaryMapData reuse) {
        byte[] bytes = BinarySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    @Override
    public int hashCode() {
        return BinarySegmentUtils.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }

    public static BinaryMapData valueOf(BinaryArrayData key, BinaryArrayData value) {
        Preconditions.checkArgument(key.segments.length == 1 && value.getSegments().length == 1);
        byte[] bytes = new byte[4 + key.sizeInBytes + value.sizeInBytes];
        MemorySegment segment = MemorySegmentFactory.wrap(bytes);
        segment.putInt(0, key.sizeInBytes);
        key.getSegments()[0].copyTo(key.getOffset(), segment, 4, key.sizeInBytes);
        value.getSegments()[0].copyTo(value.getOffset(), segment, 4 + key.sizeInBytes, value.sizeInBytes);
        BinaryMapData map = new BinaryMapData();
        map.pointTo(segment, 0, bytes.length);
        return map;
    }
}

