/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.LinkedHashSet;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.codesplit.CodeRewriter;
import org.apache.flink.table.codesplit.CodeSplitUtil;
import org.apache.flink.table.codesplit.JavaLexer;
import org.apache.flink.table.codesplit.JavaParser;
import org.apache.flink.table.codesplit.JavaParserBaseVisitor;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CharStreams;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.ParserRuleContext;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.TokenStreamRewriter;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.PredictionMode;

@Internal
public class IfStatementRewriter
implements CodeRewriter {
    private final long maxMethodLength;
    private IfStatementVisitor visitor;

    public IfStatementRewriter(String code, long maxMethodLength) {
        this.maxMethodLength = maxMethodLength;
        this.visitor = new IfStatementVisitor(code);
    }

    @Override
    public String rewrite() {
        String rewriterCode = this.visitor.rewriteAndGetCode();
        while (this.visitor.hasRewrite()) {
            this.visitor = new IfStatementVisitor(rewriterCode);
            rewriterCode = this.visitor.rewriteAndGetCode();
        }
        return rewriterCode;
    }

    private int getNumReturnsInContext(ParserRuleContext ctx) {
        ReturnCounter counter = new ReturnCounter();
        counter.visit(ctx);
        return counter.returnCount;
    }

    private static class ReturnCounter
    extends JavaParserBaseVisitor<Void> {
        private int returnCount = 0;

        private ReturnCounter() {
        }

        @Override
        public Void visitStatement(JavaParser.StatementContext ctx) {
            if (ctx.RETURN() != null) {
                ++this.returnCount;
            }
            return (Void)this.visitChildren(ctx);
        }
    }

    private class IfStatementVisitor
    extends JavaParserBaseVisitor<Void> {
        private final CommonTokenStream tokenStream;
        private final TokenStreamRewriter rewriter;
        private long rewriteCount;

        private IfStatementVisitor(String code) {
            this.tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(code)));
            this.rewriter = new TokenStreamRewriter(this.tokenStream);
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if (!"void".equals(ctx.typeTypeOrVoid().getText())) {
                return null;
            }
            final LinkedHashSet declarationContext = new LinkedHashSet();
            new JavaParserBaseVisitor<Void>(){

                @Override
                public Void visitFormalParameter(JavaParser.FormalParameterContext ctx) {
                    declarationContext.add(ctx.variableDeclaratorId().getText());
                    return null;
                }
            }.visit(ctx);
            String type = CodeSplitUtil.getContextString(ctx.typeTypeOrVoid());
            String functionName = ctx.IDENTIFIER().getText();
            String parameters = CodeSplitUtil.getContextString(ctx.formalParameters());
            String methodQualifier = "";
            if (ctx.THROWS() != null) {
                methodQualifier = " throws " + CodeSplitUtil.getContextString(ctx.qualifiedNameList());
            }
            for (JavaParser.BlockStatementContext blockStatementContext : ctx.methodBody().block().blockStatement()) {
                String newMethodCall;
                String newMethod;
                String methodDef;
                long counter;
                if (blockStatementContext.statement() == null || blockStatementContext.statement().IF() == null || (long)blockStatementContext.statement().getText().length() <= IfStatementRewriter.this.maxMethodLength) continue;
                if (this.shouldExtract(blockStatementContext.statement().statement(0))) {
                    counter = CodeSplitUtil.getCounter().incrementAndGet();
                    methodDef = type + " " + functionName + "_trueFilter" + counter + parameters + methodQualifier;
                    newMethod = methodDef + CodeSplitUtil.getContextString(blockStatementContext.statement().statement(0).block()) + "\n";
                    newMethodCall = functionName + "_trueFilter" + counter + "(" + String.join((CharSequence)", ", declarationContext) + ");\n";
                    this.rewriter.replace(blockStatementContext.statement().statement((int)0).block().start, blockStatementContext.statement().statement((int)0).block().stop, (Object)("{\n" + newMethodCall + "\n}\n"));
                    this.rewriter.insertAfter(ctx.getParent().stop, (Object)("\n" + newMethod + "\n"));
                    ++this.rewriteCount;
                }
                if (!this.shouldExtract(blockStatementContext.statement().statement(1))) continue;
                counter = CodeSplitUtil.getCounter().incrementAndGet();
                methodDef = type + " " + functionName + "_falseFilter" + counter + parameters + methodQualifier;
                newMethod = methodDef + CodeSplitUtil.getContextString(blockStatementContext.statement().statement(1).block()) + "\n";
                newMethodCall = functionName + "_falseFilter" + counter + "(" + String.join((CharSequence)", ", declarationContext) + ");\n";
                this.rewriter.replace(blockStatementContext.statement().statement((int)1).block().start, blockStatementContext.statement().statement((int)1).block().stop, (Object)("{\n" + newMethodCall + "\n}\n"));
                this.rewriter.insertAfter(ctx.getParent().stop, (Object)("\n" + newMethod + "\n"));
                ++this.rewriteCount;
            }
            return null;
        }

        private boolean shouldExtract(JavaParser.StatementContext ctx) {
            return ctx != null && ctx.block() != null && ctx.block().blockStatement() != null && ctx.block().blockStatement().size() > 1 && IfStatementRewriter.this.getNumReturnsInContext(ctx.block()) == 0;
        }

        private String rewriteAndGetCode() {
            JavaParser javaParser = new JavaParser(this.tokenStream);
            ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            this.visit(javaParser.compilationUnit());
            return this.rewriter.getText();
        }

        private boolean hasRewrite() {
            return this.rewriteCount > 0L;
        }
    }
}

